/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGatewayResponse {
    private final int statusCode;
    private final String body;
    private final Map<String, String> headers;
    private final boolean isBase64Encoded;
    private Object objectBody;

    public ApiGatewayResponse(int statusCode, String body, Map<String, String> headers, boolean isBase64Encoded) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
        this.isBase64Encoded = isBase64Encoded;
    }

    public Object _getObjectBody() {
        return this.objectBody;
    }

    public void setObjectBody(Object objectBody) {
        this.objectBody = objectBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isIsBase64Encoded() {
        return this.isBase64Encoded;
    }

    public static Builder builder() {
        Builder builder = new Builder();
        return builder.withNoCache();
    }

    public static class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private static final ObjectMapper objectMapper = new ObjectMapper();
        private int statusCode = 200;
        private Map<String, String> headers = new HashMap<String, String>();
        private String rawBody;
        private Object objectBody;
        private byte[] binaryBody;
        private boolean base64Encoded;

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withNoCache() {
            this.headers.put("Cache-Control", "no-cache, no-store, must-revalidate");
            this.headers.put("Pragma", "no-cache");
            this.headers.put("Expires", "0");
            return this;
        }

        public Builder allowCaching() {
            this.headers.remove("Cache-Control");
            this.headers.remove("Pragma");
            this.headers.remove("Expires");
            return this;
        }

        public Builder setRawBody(String rawBody) {
            this.rawBody = rawBody;
            return this;
        }

        public Builder setObjectBody(Object objectBody) {
            this.objectBody = objectBody;
            return this;
        }

        public Builder setRedirect(String url) {
            this.statusCode = 302;
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put("Location", url);
            return this;
        }

        public Builder setBinaryBody(byte[] binaryBody) {
            this.binaryBody = binaryBody;
            this.setBase64Encoded(true);
            return this;
        }

        public Builder setBase64Encoded(boolean base64Encoded) {
            this.base64Encoded = base64Encoded;
            return this;
        }

        public ApiGatewayResponse build() {
            String body = null;
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            objectMapper.setDateFormat((DateFormat)new ISO8601DateFormat());
            if (this.rawBody != null) {
                body = this.rawBody;
            } else if (this.objectBody != null) {
                try {
                    body = objectMapper.writeValueAsString(this.objectBody);
                    this.setObjectBody(this.objectBody);
                }
                catch (JsonProcessingException e) {
                    LOG.error("failed to serialize object", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else if (this.binaryBody != null) {
                body = new String(Base64.getEncoder().encode(this.binaryBody), StandardCharsets.UTF_8);
            }
            ApiGatewayResponse ret = new ApiGatewayResponse(this.statusCode, body, this.headers, this.base64Encoded);
            ret.setObjectBody(body);
            return ret;
        }
    }
}

