/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import tech.rsqn.useful.things.lambda.model.ApiGatewayResponse;

public abstract class SpringBootLambdaFunctionWrapperTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootLambdaFunctionWrapperTestSupport.class);

    protected <T> ResponseEntity handleRequest(HttpServletRequest req, HttpServletResponse resp, RequestHandler lambdaHandler) {
        return this.handleRequest(req, resp, lambdaHandler, new HashMap<String, String>());
    }

    protected <T> ResponseEntity handleRequest(HttpServletRequest req, HttpServletResponse resp, RequestHandler lambdaHandler, Map<String, String> pathVariables) {
        ObjectMapper objectMapper = new ObjectMapper();
        APIGatewayV2HTTPEvent lambdaEvent = new APIGatewayV2HTTPEvent();
        HashMap<String, String> hdrs = new HashMap<String, String>();
        Enumeration hdrEn = req.getHeaderNames();
        while (hdrEn.hasMoreElements()) {
            String n = (String)hdrEn.nextElement();
            hdrs.put(n, req.getHeader(n));
        }
        HashMap<String, String> qs = new HashMap<String, String>();
        Enumeration qsEn = req.getParameterNames();
        while (qsEn.hasMoreElements()) {
            String n = (String)qsEn.nextElement();
            qs.put(n, req.getParameter(n));
        }
        try {
            if (req.getContentLength() > 0) {
                BufferedReader reader = req.getReader();
                String body = IOUtils.toString((Reader)reader);
                lambdaEvent.setBody(body);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        lambdaEvent.setHeaders(hdrs);
        lambdaEvent.setQueryStringParameters(qs);
        APIGatewayV2HTTPEvent.RequestContext requestContext = new APIGatewayV2HTTPEvent.RequestContext();
        APIGatewayV2HTTPEvent.RequestContext.Http http = new APIGatewayV2HTTPEvent.RequestContext.Http();
        http.setMethod(req.getMethod());
        http.setPath(req.getRequestURI());
        requestContext.setHttp(http);
        lambdaEvent.setRawPath(req.getRequestURI());
        lambdaEvent.setRequestContext(requestContext);
        lambdaEvent.setPathParameters(pathVariables);
        ApiGatewayResponse ret = (ApiGatewayResponse)lambdaHandler.handleRequest((Object)lambdaEvent, this.makeContext());
        if (ret.getStatusCode() == 302) {
            try {
                resp.sendRedirect(ret.getHeaders().get("Location"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        }
        HttpHeaders h = new HttpHeaders();
        for (String n : ret.getHeaders().keySet()) {
            h.set(n, ret.getHeaders().get(n));
        }
        return new ResponseEntity(ret._getObjectBody(), (MultiValueMap)h, (HttpStatusCode)HttpStatus.valueOf((int)ret.getStatusCode()));
    }

    private Context makeContext() {
        return new Context(){

            public String getAwsRequestId() {
                return "mock";
            }

            public String getLogGroupName() {
                return null;
            }

            public String getLogStreamName() {
                return null;
            }

            public String getFunctionName() {
                return null;
            }

            public String getFunctionVersion() {
                return null;
            }

            public String getInvokedFunctionArn() {
                return null;
            }

            public CognitoIdentity getIdentity() {
                return null;
            }

            public ClientContext getClientContext() {
                return null;
            }

            public int getRemainingTimeInMillis() {
                return 0;
            }

            public int getMemoryLimitInMB() {
                return 512;
            }

            public LambdaLogger getLogger() {
                return new LambdaLogger(){

                    public void log(String s) {
                        LOG.info(s);
                    }

                    public void log(byte[] bytes) {
                        LOG.info(new String(bytes, StandardCharsets.UTF_8));
                    }
                };
            }
        };
    }
}

