/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda.model;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class HttpRequestDto {
    private String resource;
    private String path;
    private String httpMethod;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> queryStringParameters = new HashMap<String, String>();
    private Map<String, String> pathParameters = new HashMap<String, String>();
    private Map<String, String> stageVariables = new HashMap<String, String>();
    private String Body;
    private List<String> cookies;
    private String version;
    private String routeKey;
    private String rawPath;
    private String rawQueryString;
    private APIGatewayV2HTTPEvent event;
    private Object model;

    public HttpRequestDto with(APIGatewayV2HTTPEvent evt, Object model) {
        BeanUtils.copyProperties((Object)evt, (Object)this);
        this.path = evt.getRawPath();
        this.httpMethod = evt.getRequestContext().getHttp().getMethod();
        this.event = evt;
        this.Body = evt.getBody();
        this.model = model;
        return this;
    }

    public <T> T getModel() {
        return (T)this.model;
    }

    public String getParameter(String key) {
        String s = this.queryStringParameters.get(key);
        if (StringUtils.hasText((String)s)) {
            return s;
        }
        return null;
    }

    public String getHeader(String key) {
        String s = this.headers.get(key);
        if (StringUtils.hasText((String)s)) {
            return s;
        }
        return null;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public void setQueryStringParameters(Map<String, String> queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    public Map<String, String> getStageVariables() {
        return this.stageVariables;
    }

    public void setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
    }

    public String getBody() {
        return this.Body;
    }

    public void setBody(String body) {
        this.Body = body;
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<String> cookies) {
        this.cookies = cookies;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public void setRouteKey(String routeKey) {
        this.routeKey = routeKey;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public void setRawPath(String rawPath) {
        this.rawPath = rawPath;
    }

    public String getRawQueryString() {
        return this.rawQueryString;
    }

    public void setRawQueryString(String rawQueryString) {
        this.rawQueryString = rawQueryString;
    }

    public String toString() {
        return "HttpRequestDto{resource='" + this.resource + "', path='" + this.path + "', httpMethod='" + this.httpMethod + "', headers=" + this.headers + ", queryStringParameters=" + this.queryStringParameters + ", pathParameters=" + this.pathParameters + ", stageVariables=" + this.stageVariables + ", Body='" + this.Body + "', cookies=" + this.cookies + ", version='" + this.version + "', routeKey='" + this.routeKey + "', rawPath='" + this.rawPath + "', rawQueryString='" + this.rawQueryString + "'}";
    }
}

