/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda.model;

import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import tech.rsqn.useful.things.lambda.model.ApiGatewayResponse;

public class HttpResponseDto {
    private int status;
    private String body;
    private Map<String, String> headers = new HashMap<String, String>();
    private Object objectBody;
    private String redirect;

    public HttpResponseDto ok() {
        this.status = 200;
        return this;
    }

    public HttpResponseDto ok(Object b) {
        this.status = 200;
        this.body(b);
        return this;
    }

    public HttpResponseDto status(HttpStatus status) {
        this.status = status.value();
        return this;
    }

    public HttpResponseDto status(int status) {
        this.status = status;
        return this;
    }

    public HttpResponseDto status(HttpStatus status, Object b) {
        this.status = status.value();
        this.body(b);
        return this;
    }

    public HttpResponseDto status(int status, Object b) {
        this.status = status;
        this.body(b);
        return this;
    }

    public HttpResponseDto error(Object b) {
        this.status = 500;
        this.body(b);
        return this;
    }

    public HttpResponseDto redirect(String r) {
        this.redirect = r;
        this.status = 307;
        return this;
    }

    public HttpResponseDto body(Object body) {
        if (body instanceof String) {
            this.body = (String)body;
        } else {
            this.objectBody = body;
        }
        return this;
    }

    public HttpResponseDto header(String k, String v) {
        this.headers.put(k, v);
        return this;
    }

    public HttpResponseDto headers(Map<String, String> map) {
        this.headers.putAll(map);
        return this;
    }

    public ApiGatewayResponse toResponse() {
        ApiGatewayResponse.Builder builder = ApiGatewayResponse.builder().setStatusCode(this.status).setHeaders(this.headers);
        if (StringUtils.hasText((String)this.redirect)) {
            builder.setRedirect(this.redirect);
        }
        if (StringUtils.hasText((String)this.body)) {
            builder.setRawBody(this.body);
        }
        if (this.objectBody != null) {
            builder.setObjectBody(this.objectBody);
        }
        return builder.build();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Object getObjectBody() {
        return this.objectBody;
    }

    public void setObjectBody(Object objectBody) {
        this.objectBody = objectBody;
    }

    public String toString() {
        return "HttpResponseDto{status=" + this.status + ", body='" + this.body + "', headers=" + this.headers + ", objectBody=" + this.objectBody + ", redirect='" + this.redirect + "'}";
    }
}

