/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;

@NonInstantiable
public final class CollectionGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionGenerators.class);

    CollectionGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static <T> List<T> listOf(@NonNull AlchemyGenerator<T> generator) {
        return CollectionGenerators.listOf(generator, AlchemyGenerator.one(NumberGenerators.integers(5, 200)));
    }

    public static <T> List<T> listOf(@NonNull AlchemyGenerator<T> generator, int size) {
        Checks.checkThat(size > 0, "Size must be at least 1");
        Checks.checkNotNull(generator, "generator is null");
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(generator.get());
        }
        return list;
    }

    public static <T> AlchemyGenerator<T> fromList(@NonNull List<T> list) throws IllegalArgumentException {
        Checks.checkNotNull(list, "list cannot be null");
        Checks.checkThat(!list.isEmpty(), "list has no elements");
        return () -> {
            int index = AlchemyGenerator.one(NumberGenerators.integers(0, list.size()));
            return list.get(index);
        };
    }

    public static <K, V> Map<K, V> mapOf(@NonNull AlchemyGenerator<K> keyGenerator, @NonNull AlchemyGenerator<V> valueGenerator) throws IllegalArgumentException {
        int size = AlchemyGenerator.one(NumberGenerators.integers(5, 100));
        return CollectionGenerators.mapOf(keyGenerator, valueGenerator, size);
    }

    public static <K, V> Map<K, V> mapOf(@NonNull AlchemyGenerator<K> keyGenerator, @NonNull AlchemyGenerator<V> valueGenerator, int size) throws IllegalArgumentException {
        Checks.checkThat(size > 0, "size must be at least 1");
        Checks.checkNotNull(keyGenerator);
        Checks.checkNotNull(valueGenerator);
        HashMap<K, V> map = new HashMap<K, V>(size);
        for (int i = 0; i < size; ++i) {
            K key = keyGenerator.get();
            V vaue = valueGenerator.get();
            map.put(key, vaue);
        }
        return map;
    }
}

