/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.Dates;
import tech.sirwellington.alchemy.generator.TimeGenerators;

@NonInstantiable
public final class DateGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(DateGenerators.class);

    DateGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyGenerator<Date> presentDates() {
        return Dates::now;
    }

    public static AlchemyGenerator<Date> pastDates() {
        return DateGenerators.toDate(TimeGenerators.pastInstants());
    }

    public static AlchemyGenerator<Date> futureDates() {
        return DateGenerators.toDate(TimeGenerators.futureInstants());
    }

    public static AlchemyGenerator<Date> before(@NonNull Date referenceDate) throws IllegalArgumentException {
        Checks.checkNotNull(referenceDate, "referenceDate cannot be null");
        Instant instant = referenceDate.toInstant();
        return DateGenerators.toDate(TimeGenerators.before(instant));
    }

    public static AlchemyGenerator<Date> after(@NonNull Date referenceDate) throws IllegalArgumentException {
        Checks.checkNotNull(referenceDate, "referenceDate cannot be null");
        Instant instant = referenceDate.toInstant();
        return DateGenerators.toDate(TimeGenerators.after(instant));
    }

    public static AlchemyGenerator<Date> anyTime() {
        return DateGenerators.toDate(TimeGenerators.anytime());
    }

    public static AlchemyGenerator<Date> toDate(@NonNull AlchemyGenerator<Instant> generator) throws IllegalArgumentException {
        Checks.checkNotNull(generator, "generator cannot be null");
        Checks.checkNotNull(generator.get(), "generator produced null");
        return () -> Date.from((Instant)generator.get());
    }
}

