/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;

@NonInstantiable
public final class PeopleGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(PeopleGenerators.class);

    PeopleGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate");
    }

    public static AlchemyGenerator<String> names() {
        return () -> {
            String firstLetter = AlchemyGenerator.one(StringGenerators.alphabeticString(1)).toUpperCase();
            int length = AlchemyGenerator.one(NumberGenerators.integers(2, 15));
            String restOfTheName = AlchemyGenerator.one(StringGenerators.alphabeticString(length - 1)).toLowerCase();
            return firstLetter + restOfTheName;
        };
    }

    public static AlchemyGenerator<Integer> ages() {
        return NumberGenerators.integers(1, 100);
    }

    public static AlchemyGenerator<Integer> adultAges() {
        return NumberGenerators.integers(18, 100);
    }

    public static AlchemyGenerator<Integer> childAges() {
        return NumberGenerators.integers(1, 18);
    }

    public static AlchemyGenerator<Long> phoneNumbers() {
        return () -> {
            int firstPart = AlchemyGenerator.one(NumberGenerators.integers(100, 1000));
            int secondPart = AlchemyGenerator.one(NumberGenerators.integers(100, 1000));
            int thirdPart = AlchemyGenerator.one(NumberGenerators.integers(1000, 10000));
            String phoneString = String.format("%d%d%d", firstPart, secondPart, thirdPart);
            return Long.valueOf(phoneString);
        };
    }

    public static AlchemyGenerator<String> phoneNumberStrings() {
        return () -> {
            int firstPart = AlchemyGenerator.one(NumberGenerators.integers(100, 1000));
            int secondPart = AlchemyGenerator.one(NumberGenerators.integers(100, 1000));
            int thirdPart = AlchemyGenerator.one(NumberGenerators.integers(1000, 10000));
            return String.format("%d-%d-%d", firstPart, secondPart, thirdPart);
        };
    }

    public static AlchemyGenerator<String> popularEmailDomains() {
        return StringGenerators.stringsFromFixedList("yahoo.com", "google.com", "gmail.com", "sirwellington.tech", "apple.com", "icloud.com", "microsoft.com");
    }

    public static AlchemyGenerator<String> emails() {
        return PeopleGenerators.emails(PeopleGenerators.popularEmailDomains());
    }

    public static AlchemyGenerator<String> emails(@NonNull AlchemyGenerator<String> domainGenerator) throws IllegalArgumentException {
        Checks.checkNotNull(domainGenerator, "domainGenerator missing");
        Checks.checkNotEmpty(domainGenerator.get(), "Email Domain Generator returned empty String");
        return () -> {
            String username = AlchemyGenerator.one(StringGenerators.alphanumericString());
            String domain = (String)domainGenerator.get();
            return String.format("%s@%s", username, domain);
        };
    }
}

