/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;

@NonInstantiable
@Internal
class Checks {
    private static final Logger LOG = LoggerFactory.getLogger(Checks.class);

    Checks() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate class");
    }

    static void checkNotNull(Object ref) throws IllegalArgumentException {
        Checks.checkNotNull(ref, "");
    }

    static void checkNotNull(Object ref, String message) throws IllegalArgumentException {
        if (ref == null) {
            throw new IllegalArgumentException(message);
        }
    }

    static void checkThat(boolean predicate) throws IllegalArgumentException {
        Checks.checkThat(predicate, "");
    }

    static void checkThat(boolean predicate, String message) throws IllegalArgumentException {
        if (!predicate) {
            throw new IllegalArgumentException(message);
        }
    }

    static void checkNotEmpty(String string) throws IllegalArgumentException {
        Checks.checkNotEmpty(string, "");
    }

    static void checkNotEmpty(String string, String message) throws IllegalArgumentException {
        Checks.checkThat(string != null && !string.isEmpty(), message);
    }
}

