/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;

@NonInstantiable
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class BinaryGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryGenerators.class);

    BinaryGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static AlchemyGenerator<byte[]> binary(int length) throws IllegalArgumentException {
        Checks.checkThat(length >= 0, "length must be >= 0");
        return () -> RandomUtils.nextBytes((int)length);
    }

    public static AlchemyGenerator<ByteBuffer> byteBuffers(int size) throws IllegalArgumentException {
        Checks.checkThat(size >= 0, "size must be at least 0");
        AlchemyGenerator<byte[]> delegate = BinaryGenerators.binary(size);
        return () -> {
            byte[] binary = (byte[])delegate.get();
            return ByteBuffer.wrap(binary);
        };
    }

    public static AlchemyGenerator<Byte> bytes() {
        AlchemyGenerator<byte[]> delegate = BinaryGenerators.binary(1);
        return () -> {
            byte[] array = (byte[])delegate.get();
            Checks.checkThat(array != null && array.length != 0, "no Byte available to return.");
            return array[0];
        };
    }
}

