/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonNull;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BinaryGenerators;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;

@NonInstantiable
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class StringGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(StringGenerators.class);
    public static AlchemyGenerator<String> uuids = () -> UUID.randomUUID().toString();

    StringGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static AlchemyGenerator<String> strings() {
        return () -> {
            int size = AlchemyGenerator.one(NumberGenerators.integers(5, 1000));
            return RandomStringUtils.random((int)size);
        };
    }

    public static AlchemyGenerator<String> strings(int length) {
        Checks.checkThat(length > 0, "Length must be at least 1");
        return () -> RandomStringUtils.random((int)length);
    }

    public static AlchemyGenerator<String> hexadecimalString(int length) {
        Checks.checkThat(length > 0, "Length must be at least 1");
        HexBinaryAdapter hexBinaryAdapter = new HexBinaryAdapter();
        AlchemyGenerator<byte[]> binaryGenerator = BinaryGenerators.binary(length);
        return () -> {
            byte[] binary = (byte[])AlchemyGenerator.one(binaryGenerator);
            String hex = hexBinaryAdapter.marshal(binary);
            return StringUtils.left((String)hex, (int)length);
        };
    }

    public static AlchemyGenerator<String> alphabeticString(int length) throws IllegalArgumentException {
        Checks.checkThat(length > 0, "length must be > 0");
        return () -> RandomStringUtils.randomAlphabetic((int)length);
    }

    public static AlchemyGenerator<String> alphabeticString() {
        int length = AlchemyGenerator.one(NumberGenerators.integers(10, 100));
        return StringGenerators.alphabeticString(length);
    }

    public static AlchemyGenerator<String> alphanumericString() {
        int length = AlchemyGenerator.one(NumberGenerators.integers(10, 100));
        return StringGenerators.alphabeticString(length);
    }

    public static AlchemyGenerator<String> alphanumericString(int length) throws IllegalArgumentException {
        Checks.checkThat(length > 0, "length must be > 0");
        return () -> RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static AlchemyGenerator<String> numericString() {
        int length = AlchemyGenerator.one(NumberGenerators.integers(4, 25));
        return StringGenerators.numericString(length);
    }

    public static AlchemyGenerator<String> numericString(int length) throws IllegalArgumentException {
        Checks.checkThat(length > 0, "lengt must be > 0");
        AlchemyGenerator<Integer> digits = NumberGenerators.integers(0, 10);
        return () -> {
            StringBuilder builder = new StringBuilder();
            while (builder.length() < length) {
                builder.append(digits.get());
            }
            return builder.toString();
        };
    }

    public static AlchemyGenerator<String> uuids() {
        return uuids;
    }

    public static AlchemyGenerator<String> stringsFromFixedList(List<String> values) {
        Checks.checkNotNull(values);
        Checks.checkThat(!values.isEmpty(), "No values specified");
        return () -> {
            int index = NumberGenerators.integers(0, values.size()).get();
            return (String)values.get(index);
        };
    }

    public static AlchemyGenerator<String> stringsFromFixedList(String ... values) {
        Checks.checkNotNull(values);
        Checks.checkThat(values.length != 0, "No values specified");
        return StringGenerators.stringsFromFixedList(Arrays.asList(values));
    }

    public static <T> AlchemyGenerator<String> asString(@NonNull AlchemyGenerator<T> generator) throws IllegalArgumentException {
        Checks.checkNotNull(generator, "generator missing");
        return () -> {
            Object value = generator.get();
            return value != null ? value.toString() : "";
        };
    }
}

