/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.DateGenerators;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.TimeGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/DateGenerators;", "", "()V", "Companion", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class DateGenerators {
    public static final Companion Companion = new Companion(null);

    public DateGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate");
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> presentDates() {
        return Companion.presentDates();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> pastDates() {
        return Companion.pastDates();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> futureDates() {
        return Companion.futureDates();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> before(@Required @NotNull Date referenceDate) throws IllegalArgumentException {
        return Companion.before(referenceDate);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> after(@Required @NotNull Date referenceDate) throws IllegalArgumentException {
        return Companion.after(referenceDate);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> anyTime() {
        return Companion.anyTime();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> toDate(@Required @NotNull AlchemyGenerator<Instant> generator) throws IllegalArgumentException {
        return Companion.toDate(generator);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Date> datesBetween(@Required @NotNull Date startDate, @Required @NotNull Date endDate) throws IllegalArgumentException {
        return Companion.datesBetween(startDate, endDate);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u0005H\u0007J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u0005H\u0007J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0001\u0010\n\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Ltech/sirwellington/alchemy/generator/DateGenerators$Companion;", "", "()V", "after", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "Ljava/util/Date;", "referenceDate", "anyTime", "before", "datesBetween", "startDate", "endDate", "futureDates", "pastDates", "presentDates", "toDate", "generator", "Ljava/time/Instant;", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> presentDates() {
            return presentDates.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> pastDates() {
            return this.toDate(TimeGenerators.Companion.pastInstants());
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> futureDates() {
            return this.toDate(TimeGenerators.Companion.futureInstants());
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> before(@Required @NotNull Date referenceDate) throws IllegalArgumentException {
            Instant instant;
            Intrinsics.checkParameterIsNotNull((Object)referenceDate, (String)"referenceDate");
            Instant instant2 = instant = referenceDate.toInstant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"instant");
            return this.toDate(TimeGenerators.Companion.before(instant2));
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> after(@Required @NotNull Date referenceDate) throws IllegalArgumentException {
            Instant instant;
            Intrinsics.checkParameterIsNotNull((Object)referenceDate, (String)"referenceDate");
            Instant instant2 = instant = referenceDate.toInstant();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"instant");
            return this.toDate(TimeGenerators.Companion.after(instant2));
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> anyTime() {
            return this.toDate(TimeGenerators.Companion.anytime());
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> toDate(@Required @NotNull AlchemyGenerator<Instant> generator) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull(generator, (String)"generator");
            Checks.checkNotNull(generator.get(), "generator produced null");
            return new AlchemyGenerator<Date>(generator){
                final /* synthetic */ AlchemyGenerator $generator;

                public final Date get() {
                    return Date.from((Instant)this.$generator.get());
                }
                {
                    this.$generator = alchemyGenerator;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Date> datesBetween(@Required @NotNull Date startDate, @Required @NotNull Date endDate) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
            Intrinsics.checkParameterIsNotNull((Object)endDate, (String)"endDate");
            Checks.checkThat(startDate.before(endDate), "endDate must be after startDate");
            long startTime = startDate.getTime();
            long endTime = endDate.getTime();
            AlchemyGenerator<Long> timestampGenerator = NumberGenerators.Companion.longs(startTime, endTime);
            return new AlchemyGenerator<Date>(timestampGenerator){
                final /* synthetic */ AlchemyGenerator $timestampGenerator;

                @NotNull
                public final Date get() {
                    Long timestamp;
                    Long l = timestamp = (Long)this.$timestampGenerator.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"timestamp");
                    return new Date(l);
                }
                {
                    this.$timestampGenerator = alchemyGenerator;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

