/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/CollectionGenerators;", "", "()V", "Companion", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class CollectionGenerators {
    private static final Logger LOG;
    public static final Companion Companion;

    public CollectionGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate this class");
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(CollectionGenerators.class);
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> listOf(@Required @NotNull AlchemyGenerator<T> generator) {
        return Companion.listOf(generator);
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> listOf(@Required @NotNull AlchemyGenerator<T> generator, int size) {
        return Companion.listOf(generator, size);
    }

    @JvmStatic
    @NotNull
    public static final <T> AlchemyGenerator<T> fromList(@Required @NotNull List<? extends T> list) throws IllegalArgumentException {
        return Companion.fromList(list);
    }

    @JvmStatic
    @NotNull
    public static final <K, V> Map<K, V> mapOf(@Required @NotNull AlchemyGenerator<K> keyGenerator, @Required @NotNull AlchemyGenerator<V> valueGenerator) throws IllegalArgumentException {
        return Companion.mapOf(keyGenerator, valueGenerator);
    }

    @JvmStatic
    @NotNull
    public static final <K, V> Map<K, V> mapOf(@Required @NotNull AlchemyGenerator<K> keyGenerator, @Required @NotNull AlchemyGenerator<V> valueGenerator, int size) throws IllegalArgumentException {
        return Companion.mapOf(keyGenerator, valueGenerator, size);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b2\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0007J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\n\"\u0004\b\u0000\u0010\b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007H\u0007J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\n\"\u0004\b\u0000\u0010\b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J@\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u00122\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00072\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0007H\u0007JH\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u0010\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u00122\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00072\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltech/sirwellington/alchemy/generator/CollectionGenerators$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "fromList", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "T", "list", "", "listOf", "generator", "size", "", "mapOf", "", "K", "V", "keyGenerator", "valueGenerator", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T> List<T> listOf(@Required @NotNull AlchemyGenerator<T> generator) {
            Intrinsics.checkParameterIsNotNull(generator, (String)"generator");
            AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(5, 200);
            int size = ((Number)generator$iv.get()).intValue();
            return this.listOf(generator, size);
        }

        @JvmStatic
        @NotNull
        public final <T> List<T> listOf(@Required @NotNull AlchemyGenerator<T> generator, int size) {
            Intrinsics.checkParameterIsNotNull(generator, (String)"generator");
            Checks.checkThat(size >= 0, "Size must be at least 0");
            Checks.checkNotNull(generator, "generator is null");
            ArrayList<T> arrayList = new ArrayList<T>(size);
            int n = 0;
            int n2 = size;
            while (n < n2) {
                int n3;
                int n4 = n3 = n++;
                ArrayList<T> arrayList2 = arrayList;
                T t = generator.get();
                arrayList2.add(t);
            }
            List list = arrayList;
            return list;
        }

        @JvmStatic
        @NotNull
        public final <T> AlchemyGenerator<T> fromList(@Required @NotNull List<? extends T> list) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            Checks.checkNotNull(list, "list cannot be null");
            Collection collection = list;
            Checks.checkThat(!collection.isEmpty(), "list has no elements");
            return new AlchemyGenerator<T>(list){
                final /* synthetic */ List $list;

                public final T get() {
                    AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(0, this.$list.size());
                    int index = ((Number)generator$iv.get()).intValue();
                    return (T)this.$list.get(index);
                }
                {
                    this.$list = list;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final <K, V> Map<K, V> mapOf(@Required @NotNull AlchemyGenerator<K> keyGenerator, @Required @NotNull AlchemyGenerator<V> valueGenerator) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull(keyGenerator, (String)"keyGenerator");
            Intrinsics.checkParameterIsNotNull(valueGenerator, (String)"valueGenerator");
            AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(5, 100);
            int size = ((Number)generator$iv.get()).intValue();
            return this.mapOf(keyGenerator, valueGenerator, size);
        }

        @JvmStatic
        @NotNull
        public final <K, V> Map<K, V> mapOf(@Required @NotNull AlchemyGenerator<K> keyGenerator, @Required @NotNull AlchemyGenerator<V> valueGenerator, int size) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull(keyGenerator, (String)"keyGenerator");
            Intrinsics.checkParameterIsNotNull(valueGenerator, (String)"valueGenerator");
            Checks.checkThat(size > 0, "size must be at least 1");
            Checks.checkNotNull$default(keyGenerator, null, 2, null);
            Checks.checkNotNull$default(valueGenerator, null, 2, null);
            HashMap<K, V> map = new HashMap<K, V>(size);
            int n = 0;
            Iterable $receiver$iv = (Iterable)new IntRange(n, size - 1);
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator).nextInt();
                K key = keyGenerator.get();
                V value = valueGenerator.get();
                map.put(key, value);
            }
            return map;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

