/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.AlchemyResources;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.PeopleGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/PeopleGenerators;", "", "()V", "Companion", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class PeopleGenerators {
    private static final Logger LOG;
    private static final List<String> firstNames;
    private static final List<String> names;
    private static final List<String> professions;
    public static final Companion Companion;

    public PeopleGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate");
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Companion.getClass());
        firstNames = AlchemyResources.readLinesFromResource("names/first-names.txt");
        names = AlchemyResources.readLinesFromResource("names/names.txt");
        professions = AlchemyResources.readLinesFromResource("other/professions.txt");
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> names() {
        return Companion.names();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> ages() {
        return Companion.ages();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> adultAges() {
        return Companion.adultAges();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> childAges() {
        return Companion.childAges();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Long> phoneNumbers() {
        return Companion.phoneNumbers();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> phoneNumberStrings() {
        return Companion.phoneNumberStrings();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> popularEmailDomains() {
        return Companion.popularEmailDomains();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AlchemyGenerator<String> emails(@Required @NotNull AlchemyGenerator<String> domainGenerator) throws IllegalArgumentException {
        return Companion.emails(domainGenerator);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AlchemyGenerator<String> emails() throws IllegalArgumentException {
        return tech.sirwellington.alchemy.generator.PeopleGenerators$Companion.emails$default(Companion, null, 1, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u000e\b\u0003\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\rH\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltech/sirwellington/alchemy/generator/PeopleGenerators$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "firstNames", "", "", "", "names", "professions", "adultAges", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "", "ages", "childAges", "emails", "domainGenerator", "phoneNumberStrings", "phoneNumbers", "", "popularEmailDomains", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> names() {
            List list = names;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.names");
            Collection collection = list;
            if (!collection.isEmpty()) {
                List list2 = names;
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"names");
                return StringGenerators.Companion.stringsFromFixedList(list2);
            }
            return names.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> ages() {
            return NumberGenerators.Companion.integers(1, 100);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> adultAges() {
            return NumberGenerators.Companion.integers(18, 100);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> childAges() {
            return NumberGenerators.Companion.integers(1, 18);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Long> phoneNumbers() {
            return phoneNumbers.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> phoneNumberStrings() {
            return phoneNumberStrings.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> popularEmailDomains() {
            return StringGenerators.Companion.stringsFromFixedList("yahoo.com", "google.com", "gmail.com", "sirwellington.tech", "apple.com", "icloud.com", "microsoft.com");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AlchemyGenerator<String> emails(@Required @NotNull AlchemyGenerator<String> domainGenerator) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull(domainGenerator, (String)"domainGenerator");
            Checks.checkNotEmpty(domainGenerator.get(), "Email Domain Generator returned empty String");
            return new AlchemyGenerator<String>(domainGenerator){
                final /* synthetic */ AlchemyGenerator $domainGenerator;

                @NotNull
                public final String get() {
                    Object generator$iv = PeopleGenerators.Companion.names();
                    Object object = generator$iv = generator$iv.get();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string = ((String)object).toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                    String username = string;
                    String domain = (String)this.$domainGenerator.get();
                    return username + '@' + domain;
                }
                {
                    this.$domainGenerator = alchemyGenerator;
                }
            };
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ AlchemyGenerator emails$default(Companion companion, AlchemyGenerator alchemyGenerator, int n, Object object) throws IllegalArgumentException {
            if ((n & 1) != 0) {
                alchemyGenerator = companion.popularEmailDomains();
            }
            return companion.emails(alchemyGenerator);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AlchemyGenerator<String> emails() throws IllegalArgumentException {
            return tech.sirwellington.alchemy.generator.PeopleGenerators$Companion.emails$default(this, null, 1, null);
        }

        @NotNull
        public final AlchemyGenerator<String> professions() {
            AlchemyGenerator<String> alchemyGenerator;
            List list = professions;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"professions");
            Collection collection = list;
            if (!collection.isEmpty()) {
                List list2 = professions;
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"professions");
                alchemyGenerator = StringGenerators.Companion.stringsFromFixedList(list2);
            } else {
                alchemyGenerator = StringGenerators.Companion.alphabeticStrings(10);
            }
            return alchemyGenerator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

