/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.AlchemyResources;
import tech.sirwellington.alchemy.generator.BooleanGenerators;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.PeopleGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/sirwellington/alchemy/generator/PlaceGenerators;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cities", "", "", "", "country", "places", "states", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "countries", "fullAddresses", "isUSAddress", "", "streetAddresses", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class PlaceGenerators {
    private static final Logger LOG;
    private static final List<String> cities;
    private static final List<String> states;
    private static final List<String> places;
    private static final List<String> country;
    public static final PlaceGenerators INSTANCE;

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> cities() {
        List<String> list = cities;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"cities");
        return StringGenerators.Companion.stringsFromFixedList(list);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> states() {
        List<String> list = states;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"states");
        return StringGenerators.Companion.stringsFromFixedList(list);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> countries() {
        List<String> list = country;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"country");
        return StringGenerators.Companion.stringsFromFixedList(list);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> streetAddresses() {
        AlchemyGenerator<Boolean> booleans2 = BooleanGenerators.Companion.booleans();
        AlchemyGenerator<String> streetNames = PeopleGenerators.Companion.names();
        AlchemyGenerator<Integer> streetNumbers = NumberGenerators.Companion.integers(100, 10000);
        AlchemyGenerator<Integer> blockNumbers = NumberGenerators.Companion.integers(1, 300);
        List compasses = CollectionsKt.listOf((Object[])new String[]{"N", "S", "E", "W"});
        List endings = CollectionsKt.listOf((Object[])new String[]{"Blvd", "St", "Ave", "Pl", "Rd"});
        return new AlchemyGenerator<String>(streetNumbers, blockNumbers, streetNames, compasses, endings, booleans2){
            final /* synthetic */ AlchemyGenerator $streetNumbers;
            final /* synthetic */ AlchemyGenerator $blockNumbers;
            final /* synthetic */ AlchemyGenerator $streetNames;
            final /* synthetic */ List $compasses;
            final /* synthetic */ List $endings;
            final /* synthetic */ AlchemyGenerator $booleans;

            @NotNull
            public final String get() {
                AlchemyGenerator generator$iv = this.$streetNumbers;
                int streetNumber = ((Number)generator$iv.get()).intValue();
                AlchemyGenerator generator$iv2 = this.$blockNumbers;
                int blockNumber = ((Number)generator$iv2.get()).intValue();
                AlchemyGenerator generator$iv3 = this.$streetNames;
                String streetName = (String)generator$iv3.get();
                String direction = (String)CollectionsKt.first((List)CollectionsKt.shuffled((Iterable)this.$compasses));
                String ending = (String)CollectionsKt.first((List)CollectionsKt.shuffled((Iterable)this.$endings));
                AlchemyGenerator generator$iv4 = this.$booleans;
                boolean useCityBlockNumber = (Boolean)generator$iv4.get();
                AlchemyGenerator generator$iv5 = this.$booleans;
                boolean useDirection = (Boolean)generator$iv5.get();
                return useCityBlockNumber && useDirection ? "" + streetNumber + ' ' + direction + ' ' + blockNumber + " St" : (useCityBlockNumber ? "" + streetNumber + ' ' + blockNumber + " St" : (useDirection ? "" + streetNumber + ' ' + direction + ' ' + streetName + ' ' + ending : "" + streetNumber + ' ' + streetName + ' ' + ending));
            }
            {
                this.$streetNumbers = alchemyGenerator;
                this.$blockNumbers = alchemyGenerator2;
                this.$streetNames = alchemyGenerator3;
                this.$compasses = list;
                this.$endings = list2;
                this.$booleans = alchemyGenerator4;
            }
        };
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AlchemyGenerator<String> fullAddresses(boolean isUSAddress) {
        AlchemyGenerator<String> streetAddresses2 = PlaceGenerators.streetAddresses();
        AlchemyGenerator<String> cities = PlaceGenerators.cities();
        AlchemyGenerator<String> states = PlaceGenerators.states();
        AlchemyGenerator<String> countries = PlaceGenerators.countries();
        return new AlchemyGenerator<String>(streetAddresses2, cities, states, countries, isUSAddress){
            final /* synthetic */ AlchemyGenerator $streetAddresses;
            final /* synthetic */ AlchemyGenerator $cities;
            final /* synthetic */ AlchemyGenerator $states;
            final /* synthetic */ AlchemyGenerator $countries;
            final /* synthetic */ boolean $isUSAddress;

            @NotNull
            public final String get() {
                AlchemyGenerator generator$iv = this.$streetAddresses;
                String streetAddress = (String)generator$iv.get();
                AlchemyGenerator generator$iv2 = this.$cities;
                String city = (String)generator$iv2.get();
                AlchemyGenerator generator$iv3 = this.$states;
                String state = (String)generator$iv3.get();
                AlchemyGenerator generator$iv4 = this.$countries;
                String country = (String)generator$iv4.get();
                return this.$isUSAddress ? streetAddress + ' ' + city + ", " + state + " United States" : streetAddress + ' ' + city + ", " + country;
            }
            {
                this.$streetAddresses = alchemyGenerator;
                this.$cities = alchemyGenerator2;
                this.$states = alchemyGenerator3;
                this.$countries = alchemyGenerator4;
                this.$isUSAddress = bl;
            }
        };
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ AlchemyGenerator fullAddresses$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return PlaceGenerators.fullAddresses(bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AlchemyGenerator<String> fullAddresses() {
        return PlaceGenerators.fullAddresses$default(false, 1, null);
    }

    private PlaceGenerators() {
    }

    static {
        PlaceGenerators placeGenerators;
        INSTANCE = placeGenerators = new PlaceGenerators();
        LOG = LoggerFactory.getLogger(placeGenerators.getClass());
        cities = AlchemyResources.readLinesFromResource("places/cities.txt");
        states = AlchemyResources.readLinesFromResource("places/states.txt");
        places = AlchemyResources.readLinesFromResource("places/places.txt");
        country = AlchemyResources.readLinesFromResource("places/countries.txt");
    }
}

