/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.List;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BinaryGenerators;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/StringGenerators;", "", "()V", "Companion", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class StringGenerators {
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final AlchemyGenerator<String> uuids;
    public static final Companion Companion;

    public StringGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate this class");
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(StringGenerators.class);
        uuids = Companion.uuids.1.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> strings() {
        return Companion.strings();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> strings(int length) {
        return Companion.strings(length);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> hexadecimalString(int length) {
        return Companion.hexadecimalString(length);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> alphabeticStrings(int length) throws IllegalArgumentException {
        return Companion.alphabeticStrings(length);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> alphabeticStrings() {
        return Companion.alphabeticStrings();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> alphanumericStrings() {
        return Companion.alphanumericStrings();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> alphanumericStrings(int length) throws IllegalArgumentException {
        return Companion.alphanumericStrings(length);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> numericStrings() {
        return Companion.numericStrings();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> numericStrings(int length) throws IllegalArgumentException {
        return Companion.numericStrings(length);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> uuids() {
        return Companion.uuids();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> stringsFromFixedList(@NotNull List<String> values) {
        return Companion.stringsFromFixedList(values);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> stringsFromFixedList(String ... values) {
        return Companion.stringsFromFixedList(values);
    }

    @JvmStatic
    @NotNull
    public static final <T> AlchemyGenerator<String> asString(@Required @NotNull AlchemyGenerator<T> generator) throws IllegalArgumentException {
        return Companion.asString(generator);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\"\u0004\b\u0000\u0010\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0015\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0007J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltech/sirwellington/alchemy/generator/StringGenerators$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "uuids", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "", "alphabeticStrings", "length", "", "alphanumericStrings", "asString", "T", "generator", "hexadecimalString", "numericStrings", "strings", "stringsFromFixedList", "values", "", "([Ljava/lang/String;)Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> strings() {
            return strings.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> strings(int length) {
            Checks.checkThat(length > 0, "Length must be at least 1");
            return new AlchemyGenerator<String>(length){
                final /* synthetic */ int $length;

                public final String get() {
                    return RandomStringUtils.random((int)this.$length);
                }
                {
                    this.$length = n;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> hexadecimalString(int length) {
            Checks.checkThat(length > 0, "Length must be at least 1");
            HexBinaryAdapter hexBinaryAdapter = new HexBinaryAdapter();
            AlchemyGenerator<byte[]> binaryGenerator = BinaryGenerators.Companion.binary(length);
            return new AlchemyGenerator<String>(binaryGenerator, hexBinaryAdapter, length){
                final /* synthetic */ AlchemyGenerator $binaryGenerator;
                final /* synthetic */ HexBinaryAdapter $hexBinaryAdapter;
                final /* synthetic */ int $length;

                public final String get() {
                    AlchemyGenerator generator$iv = this.$binaryGenerator;
                    byte[] binary2 = (byte[])generator$iv.get();
                    String hex = this.$hexBinaryAdapter.marshal(binary2);
                    return StringUtils.left((String)hex, (int)this.$length);
                }
                {
                    this.$binaryGenerator = alchemyGenerator;
                    this.$hexBinaryAdapter = hexBinaryAdapter;
                    this.$length = n;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> alphabeticStrings(int length) throws IllegalArgumentException {
            Checks.checkThat(length > 0, "length must be > 0");
            return new AlchemyGenerator<String>(length){
                final /* synthetic */ int $length;

                public final String get() {
                    return RandomStringUtils.randomAlphabetic((int)this.$length);
                }
                {
                    this.$length = n;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> alphabeticStrings() {
            AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(10, 100);
            int length = ((Number)generator$iv.get()).intValue();
            return this.alphabeticStrings(length);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> alphanumericStrings() {
            AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(10, 100);
            int length = ((Number)generator$iv.get()).intValue();
            return this.alphabeticStrings(length);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> alphanumericStrings(int length) throws IllegalArgumentException {
            Checks.checkThat(length > 0, "length must be > 0");
            return new AlchemyGenerator<String>(length){
                final /* synthetic */ int $length;

                public final String get() {
                    return RandomStringUtils.randomAlphanumeric((int)this.$length);
                }
                {
                    this.$length = n;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> numericStrings() {
            AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(4, 25);
            int length = ((Number)generator$iv.get()).intValue();
            return this.numericStrings(length);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> numericStrings(int length) throws IllegalArgumentException {
            Checks.checkThat(length > 0, "length must be > 0");
            AlchemyGenerator<Integer> digits = NumberGenerators.Companion.integers(0, 10);
            return new AlchemyGenerator<String>(length, digits){
                final /* synthetic */ int $length;
                final /* synthetic */ AlchemyGenerator $digits;

                @NotNull
                public final String get() {
                    StringBuilder builder = new StringBuilder();
                    while (builder.length() < this.$length) {
                        T t = this.$digits.get();
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"digits.get()");
                        builder.append(((Number)t).intValue());
                    }
                    return builder.toString();
                }
                {
                    this.$length = n;
                    this.$digits = alchemyGenerator;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> uuids() {
            return uuids;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> stringsFromFixedList(@NotNull List<String> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Checks.checkNotNull$default(values, null, 2, null);
            Checks.checkThat(!values.isEmpty(), "No values specified");
            return new AlchemyGenerator<String>(values){
                final /* synthetic */ List $values;

                @NotNull
                public final String get() {
                    Integer index;
                    Integer n = index = NumberGenerators.Companion.integers(0, this.$values.size()).get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"index");
                    return (String)this.$values.get(n);
                }
                {
                    this.$values = list;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> stringsFromFixedList(String ... values) {
            String[] stringArray;
            Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
            Checks.checkNotNull$default(values, null, 2, null);
            String[] stringArray2 = stringArray = values;
            Checks.checkThat(!(stringArray2.length == 0), "No values specified");
            return this.stringsFromFixedList(ArraysKt.toList((Object[])values));
        }

        @JvmStatic
        @NotNull
        public final <T> AlchemyGenerator<String> asString(@Required @NotNull AlchemyGenerator<T> generator) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull(generator, (String)"generator");
            Checks.checkNotNull(generator, "generator missing");
            return new AlchemyGenerator<String>(generator){
                final /* synthetic */ AlchemyGenerator $generator;

                @NotNull
                public final String get() {
                    T value = this.$generator.get();
                    T t = value;
                    if (t == null || (t = t.toString()) == null) {
                        t = "";
                    }
                    return t;
                }
                {
                    this.$generator = alchemyGenerator;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

