/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.Required;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.TimeGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/TimeGenerators;", "", "()V", "Companion", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class TimeGenerators {
    private static final Logger LOG;
    public static final Companion Companion;

    public TimeGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate");
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(TimeGenerators.class);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Instant> presentInstants() {
        return Companion.presentInstants();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Instant> pastInstants() {
        return Companion.pastInstants();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Instant> futureInstants() {
        return Companion.futureInstants();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Instant> before(@Required @NotNull Instant instant) throws IllegalArgumentException {
        return Companion.before(instant);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Instant> after(@Required @NotNull Instant instant) throws IllegalArgumentException {
        return Companion.after(instant);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Instant> anytime() {
        return Companion.anytime();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Instant> timesBetween(@Required @NotNull Instant startTime, @Required @NotNull Instant endTime) throws IllegalArgumentException {
        return Companion.timesBetween(startTime, endTime);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\bH\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\bH\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\u0010\u001a\u00020\b2\b\b\u0001\u0010\u0011\u001a\u00020\bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltech/sirwellington/alchemy/generator/TimeGenerators$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "after", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "Ljava/time/Instant;", "instant", "anytime", "before", "futureInstants", "pastInstants", "presentInstants", "timesBetween", "startTime", "endTime", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Instant> presentInstants() {
            return presentInstants.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Instant> pastInstants() {
            Instant instant = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.now()");
            return this.before(instant);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Instant> futureInstants() {
            return futureInstants.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Instant> before(@Required @NotNull Instant instant) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull((Object)instant, (String)"instant");
            Checks.checkNotNull(instant, "instant cannot be null");
            return new AlchemyGenerator<Instant>(instant){
                final /* synthetic */ Instant $instant;

                public final Instant get() {
                    AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(1, 1000);
                    int daysBefore = ((Number)generator$iv.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv2 = NumberGenerators.Companion.integers(0, 100);
                    int hoursBefore = ((Number)generator$iv2.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv3 = NumberGenerators.Companion.integers(0, 60);
                    int minutesBefore = ((Number)generator$iv3.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv4 = NumberGenerators.Companion.integers(0, 60);
                    int secondsBefore = ((Number)generator$iv4.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv5 = NumberGenerators.Companion.integers(0, 1000);
                    int millisecondsBefore = ((Number)generator$iv5.get()).intValue();
                    return this.$instant.minus(daysBefore, ChronoUnit.DAYS).minus(hoursBefore, ChronoUnit.HOURS).minus(minutesBefore, ChronoUnit.MINUTES).minus(secondsBefore, ChronoUnit.SECONDS).minus(millisecondsBefore, ChronoUnit.MILLIS);
                }
                {
                    this.$instant = instant;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Instant> after(@Required @NotNull Instant instant) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull((Object)instant, (String)"instant");
            Checks.checkNotNull(instant, "instant cannot be null");
            return new AlchemyGenerator<Instant>(instant){
                final /* synthetic */ Instant $instant;

                public final Instant get() {
                    AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(1, 11000);
                    int daysAhead = ((Number)generator$iv.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv2 = NumberGenerators.Companion.integers(0, 100);
                    int hoursAhead = ((Number)generator$iv2.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv3 = NumberGenerators.Companion.integers(0, 60);
                    int minutesAhead = ((Number)generator$iv3.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv4 = NumberGenerators.Companion.integers(0, 60);
                    int secondsAhead = ((Number)generator$iv4.get()).intValue();
                    AlchemyGenerator<Integer> generator$iv5 = NumberGenerators.Companion.integers(0, 1000);
                    int millisecondsAhead = ((Number)generator$iv5.get()).intValue();
                    return this.$instant.plus((long)daysAhead, ChronoUnit.DAYS).plus((long)hoursAhead, ChronoUnit.HOURS).plus((long)minutesAhead, ChronoUnit.MINUTES).plus((long)secondsAhead, ChronoUnit.SECONDS).plus((long)millisecondsAhead, ChronoUnit.MILLIS);
                }
                {
                    this.$instant = instant;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Instant> anytime() {
            return anytime.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Instant> timesBetween(@Required @NotNull Instant startTime, @Required @NotNull Instant endTime) throws IllegalArgumentException {
            Intrinsics.checkParameterIsNotNull((Object)startTime, (String)"startTime");
            Intrinsics.checkParameterIsNotNull((Object)endTime, (String)"endTime");
            Checks.checkNotNull(startTime, "startTime is null");
            Checks.checkNotNull(endTime, "endTime is null");
            Checks.checkThat(startTime.isBefore(endTime), "startTime must be before endTime");
            long epochOfStart = startTime.toEpochMilli();
            long epochOfEnd = endTime.toEpochMilli();
            AlchemyGenerator<Long> timestampGenerator = NumberGenerators.Companion.longs(epochOfStart, epochOfEnd);
            return new AlchemyGenerator<Instant>(timestampGenerator){
                final /* synthetic */ AlchemyGenerator $timestampGenerator;

                public final Instant get() {
                    Long timestamp;
                    Long l = timestamp = (Long)this.$timestampGenerator.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"timestamp");
                    return Instant.ofEpochMilli(l);
                }
                {
                    this.$timestampGenerator = alchemyGenerator;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

