/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.io.ByteStreamsKt;
import kotlin.text.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;

final class AlchemyResources {
    private static final Logger LOG = LoggerFactory.getLogger(AlchemyResources.class);

    AlchemyResources() {
    }

    static List<String> readLinesFromResource(String path) {
        String file = AlchemyResources.tryToLoadResource(path);
        if (file == null || file.isEmpty()) {
            return Collections.emptyList();
        }
        String[] lines = file.split("\n");
        LOG.info("Successfully read [{}] lines from resource [{}]", (Object)lines.length, (Object)path);
        return Arrays.asList(lines);
    }

    private static String tryToLoadResource(String path) {
        ClassLoader classLoader = AlchemyGenerator.class.getClassLoader();
        if (classLoader == null) {
            return null;
        }
        URL url = classLoader.getResource(path);
        if (url == null) {
            LOG.warn("Could not load resource at [$path]");
            return null;
        }
        byte[] bytes2 = AlchemyResources.tryToReadBytes(url);
        if (bytes2 == null) {
            return null;
        }
        return new String(bytes2, Charsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] tryToReadBytes(URL url) {
        try (InputStream istream = url.openStream();){
            byte[] bytes2;
            byte[] byArray = bytes2 = ByteStreamsKt.readBytes((InputStream)istream, (int)8192);
            return byArray;
        }
        catch (IOException ex) {
            LOG.warn("Failed to read resource at {}", (Object)url, (Object)ex);
            return null;
        }
    }
}

