/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BinaryGenerators;
import tech.sirwellington.alchemy.generator.BooleanGenerators;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.DateGenerators;
import tech.sirwellington.alchemy.generator.NetworkGenerators;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.ObjectGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;
import tech.sirwellington.alchemy.generator.TimeGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0016\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0005H\u0002J%\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001bJN\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00052\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002J>\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010$\u001a\u00020\u001e2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00052\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002J@\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u001a2\f\b\u0002\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00052\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002JB\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00052\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002J2\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010+\u001a\u00020\u001e2\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002J>\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010-\u001a\u00020\u001a2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00052\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002JL\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00052\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002J\u001a\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J!\u00100\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u00101J4\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002J%\u00105\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u00106\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0005H\u0002\u00a2\u0006\u0002\u00107J\u0014\u00108\u001a\u00020\u00132\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u0010:\u001a\u00020\u00132\n\u0010 \u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010;\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010<\u001a\u00020\u00132\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0014\u0010=\u001a\u00020\u00132\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u001c\u0010>\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0005H\u0002J\u0014\u0010?\u001a\u00020\u00132\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010@\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001b\u0010A\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0006\"\n\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0001H\u0086\bJ&\u0010A\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0006\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0005H\u0007JB\u0010A\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0006\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00052\u001a\u0010B\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0007JC\u0010C\u001a\u000203\"\b\b\u0000\u0010\u0014*\u00020\u00012\u0006\u0010D\u001a\u0002H\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u001a\u0010!\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\"H\u0002\u00a2\u0006\u0002\u0010EJ\u0010\u0010F\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u000fH\u0002J\f\u0010G\u001a\u00020\u0013*\u00020\u001eH\u0002J#\u0010H\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u00140\u0005H\u0002\u00a2\u0006\u0002\u00107R\"\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u000b0\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006I"}, d2={"Ltech/sirwellington/alchemy/generator/ObjectGenerators;", "", "()V", "DEFAULT_GENERATOR_MAPPINGS", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "charGenerator", "", "shortGenerator", "", "firstAvailableConstructor", "Ljava/lang/reflect/Constructor;", "getFirstAvailableConstructor", "(Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", "canInstantiate", "", "T", "classOfPojo", "createValuesFor", "", "args", "", "Ljava/lang/reflect/Parameter;", "([Ljava/lang/reflect/Parameter;)Ljava/util/List;", "determineGeneratorFor", "field", "Ljava/lang/reflect/Field;", "parameter", "typeOfField", "generatorMappings", "", "determineGeneratorForCollectionField", "collectionField", "collectionType", "determineGeneratorForCollectionParameter", "collectionParameter", "determineGeneratorForCollectionWithValueType", "valueType", "determineGeneratorForMapField", "mapField", "determineGeneratorForMapParameter", "mapParameter", "generatorForCollectionType", "generatorForEnumType", "getValueFor", "(Ljava/lang/reflect/Parameter;)Ljava/lang/Object;", "injectField", "", "pojo", "instantiate", "classOfT", "(Ljava/lang/Class;)Ljava/lang/Object;", "isCollectionType", "type", "isEnumType", "isFinal", "isListType", "isMapType", "isPrimitiveClass", "isSetType", "isStatic", "pojos", "customMappings", "tryInjectField", "instance", "(Ljava/lang/Object;Ljava/lang/reflect/Field;Ljava/util/Map;)V", "hasNoParameters", "lacksGenericTypeArguments", "tryToInstantiate", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class ObjectGenerators {
    private static final Logger LOG;
    private static final ConcurrentHashMap<Class<?>, AlchemyGenerator<?>> DEFAULT_GENERATOR_MAPPINGS;
    private static final AlchemyGenerator<Short> shortGenerator;
    private static final AlchemyGenerator<Character> charGenerator;
    public static final ObjectGenerators INSTANCE;

    @JvmStatic
    @NotNull
    public static final <T> AlchemyGenerator<T> pojos(@NotNull Class<T> classOfPojo) {
        Intrinsics.checkParameterIsNotNull(classOfPojo, (String)"classOfPojo");
        return ObjectGenerators.pojos(classOfPojo, (Map)DEFAULT_GENERATOR_MAPPINGS);
    }

    private final <T> AlchemyGenerator<T> pojos() {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return ObjectGenerators.pojos(Object.class);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final <T> AlchemyGenerator<T> pojos(@NotNull Class<T> classOfPojo, @NotNull Map<Class<?>, ? extends AlchemyGenerator<?>> customMappings) {
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(classOfPojo, (String)"classOfPojo");
        Intrinsics.checkParameterIsNotNull(customMappings, (String)"customMappings");
        Checks.checkNotNull(classOfPojo, "missing class of POJO");
        if (customMappings.containsKey(classOfPojo)) {
            AlchemyGenerator<?> alchemyGenerator = customMappings.get(classOfPojo);
            if (alchemyGenerator == null) {
                throw new TypeCastException("null cannot be cast to non-null type tech.sirwellington.alchemy.generator.AlchemyGenerator<T>");
            }
            return alchemyGenerator;
        }
        Checks.checkThat(INSTANCE.canInstantiate(classOfPojo), "cannot instantiate class: " + classOfPojo);
        Field[] fieldArray = classOfPojo.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldArray, (String)"classOfPojo.declaredFields");
        Object $receiver$iv = fieldArray;
        Field[] fieldArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void f;
            void v2 = f = (element$iv$iv = $receiver$iv$iv[i]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"f");
            if (!(!INSTANCE.isStatic((Field)v2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Field f;
            Object element$iv$iv = iterator.next();
            Field field = f = (Field)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"f");
            if (!(!INSTANCE.isFinal(field))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validFields = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new AlchemyGenerator<T>(classOfPojo, validFields, customMappings){
            final /* synthetic */ Class $classOfPojo;
            final /* synthetic */ List $validFields;
            final /* synthetic */ Map $customMappings;

            @Nullable
            public final T invoke() {
                Object object = ObjectGenerators.access$tryToInstantiate(ObjectGenerators.INSTANCE, this.$classOfPojo);
                if (object == null) {
                    return null;
                }
                Object instance = object;
                Iterable $receiver$iv = this.$validFields;
                for (T element$iv : $receiver$iv) {
                    Field it;
                    Field field = it = (Field)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"it");
                    ObjectGenerators.access$tryInjectField(ObjectGenerators.INSTANCE, instance, field, this.$customMappings);
                }
                return (T)instance;
            }
            {
                this.$classOfPojo = clazz;
                this.$validFields = list;
                this.$customMappings = map;
            }
        };
    }

    private final <T> boolean canInstantiate(Class<T> classOfPojo) {
        return this.tryToInstantiate(classOfPojo) != null;
    }

    private final <T> T tryToInstantiate(@NotNull Class<T> $receiver) {
        T t;
        try {
            t = this.instantiate($receiver);
        }
        catch (Exception ex) {
            LOG.warn("cannot instantiate type " + $receiver);
            t = null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T instantiate(Class<T> classOfT) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Collection $receiver$iv;
        Constructor<?> defaultConstructor = this.getFirstAvailableConstructor(classOfT);
        boolean originalAccessibility = defaultConstructor.isAccessible();
        Parameter[] args = defaultConstructor.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
        Collection collection = $receiver$iv = (Collection)this.createValuesFor(args);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] values = objectArray;
        LOG.debug("Constructor parameters for " + classOfT + " are " + args);
        try {
            defaultConstructor.setAccessible(true);
            Object obj = defaultConstructor.newInstance(Arrays.copyOf(values, values.length));
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            Object obj2 = obj;
            return (T)obj2;
        }
        finally {
            defaultConstructor.setAccessible(originalAccessibility);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> createValuesFor(Parameter[] args) {
        void $receiver$iv$iv;
        Parameter[] $receiver$iv;
        Parameter[] parameterArray = args;
        if (parameterArray.length == 0) {
            return CollectionsKt.emptyList();
        }
        Parameter[] parameterArray2 = $receiver$iv = args;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        int n = ((void)$receiver$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var8_8 = item$iv$iv = $receiver$iv$iv[i];
            Collection collection = destination$iv$iv;
            Object t = INSTANCE.getValueFor((Parameter)it);
            collection.add(t);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final <T> void tryInjectField(T instance, Field field, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        try {
            this.injectField(instance, field, generatorMappings);
        }
        catch (Exception ex) {
            LOG.warn("Could not inject field " + field, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void injectField(Object pojo, Field field, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) throws IllegalArgumentException, IllegalAccessException {
        Class typeOfField = field.getType();
        Class clazz = typeOfField = ClassUtils.primitiveToWrapper(typeOfField);
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"typeOfField");
        AlchemyGenerator<?> generator = this.determineGeneratorFor(field, null, clazz, generatorMappings);
        if (generator == null) {
            LOG.warn("Could not find a suitable AlchemyGenerator for field {} with type {}", (Object)field, (Object)typeOfField);
            return;
        }
        Object value = generator.get();
        boolean originalAccessibility = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(pojo, value);
        }
        finally {
            field.setAccessible(originalAccessibility);
        }
    }

    private final <T> T getValueFor(Parameter parameter) {
        AlchemyGenerator generator;
        Class<?> clazz = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"parameter.type");
        Map map = DEFAULT_GENERATOR_MAPPINGS;
        Parameter parameter2 = parameter;
        Class<?> clazz2 = clazz;
        AlchemyGenerator alchemyGenerator = generator = ObjectGenerators.determineGeneratorFor$default(this, null, parameter2, clazz2, map, 1, null);
        Object object = alchemyGenerator != null ? alchemyGenerator.get() : null;
        if (!(object instanceof Object)) {
            object = null;
        }
        return object;
    }

    private final AlchemyGenerator<?> determineGeneratorFor(Field field, Parameter parameter, Class<?> typeOfField, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        AlchemyGenerator<?> generator = generatorMappings.get(typeOfField);
        if (generator != null) {
            return generator;
        }
        if (this.isCollectionType(typeOfField)) {
            return this.generatorForCollectionType(field, parameter, typeOfField, generatorMappings);
        }
        if (this.isEnumType(typeOfField)) {
            return this.generatorForEnumType(typeOfField);
        }
        generator = ObjectGenerators.pojos(typeOfField);
        return generator;
    }

    static /* bridge */ /* synthetic */ AlchemyGenerator determineGeneratorFor$default(ObjectGenerators objectGenerators, Field field, Parameter parameter, Class clazz, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            field = null;
        }
        if ((n & 2) != 0) {
            parameter = null;
        }
        return objectGenerators.determineGeneratorFor(field, parameter, clazz, map);
    }

    private final AlchemyGenerator<?> generatorForEnumType(Class<?> typeOfField) {
        Object[] enumValues = typeOfField.getEnumConstants();
        if (enumValues == null) {
            LOG.warn("Enum Class {} has no Enum Values: " + typeOfField);
            return null;
        }
        return new AlchemyGenerator<Object>(enumValues){
            final /* synthetic */ Object[] $enumValues;

            public final Object get() {
                AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(0, this.$enumValues.length);
                int position = ((Number)generator$iv.get()).intValue();
                return this.$enumValues[position];
            }
            {
                this.$enumValues = objectArray;
            }
        };
    }

    private final AlchemyGenerator<?> generatorForCollectionType(Field field, Parameter parameter, Class<?> typeOfField, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        if (field != null) {
            if (this.lacksGenericTypeArguments(field)) {
                LOG.warn("POJO {} contains a Collection field {} which is not type-parametrized. Cannot inject.", field.getDeclaringClass(), (Object)field);
                return null;
            }
            return this.determineGeneratorForCollectionField(field, typeOfField, generatorMappings);
        }
        if (parameter != null) {
            if (!(parameter.getParameterizedType() instanceof ParameterizedType)) {
                LOG.warn("POJO " + typeOfField + " contains a Collection parameter " + parameter + " which is not type-parameterized. Cannot inject.");
                return null;
            }
            return this.determineGeneratorForCollectionParameter(parameter, typeOfField, generatorMappings);
        }
        LOG.warn("Cannot Instantiate: No generic information available in order to generate values for " + typeOfField);
        return null;
    }

    static /* bridge */ /* synthetic */ AlchemyGenerator generatorForCollectionType$default(ObjectGenerators objectGenerators, Field field, Parameter parameter, Class clazz, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            parameter = null;
        }
        return objectGenerators.generatorForCollectionType(field, parameter, clazz, map);
    }

    private final boolean isCollectionType(Class<?> type) {
        return this.isListType(type) | this.isSetType(type) | this.isMapType(type);
    }

    private final boolean isListType(Class<?> type) {
        return List.class.isAssignableFrom(type);
    }

    private final boolean isSetType(Class<?> type) {
        return Set.class.isAssignableFrom(type);
    }

    private final boolean isMapType(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    private final boolean lacksGenericTypeArguments(@NotNull Field $receiver) {
        return !($receiver.getGenericType() instanceof ParameterizedType);
    }

    private final AlchemyGenerator<?> determineGeneratorForCollectionField(Field collectionField, Class<?> collectionType, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        if (this.isMapType(collectionType)) {
            return this.determineGeneratorForMapField(collectionField, generatorMappings);
        }
        Type type = collectionField.getGenericType();
        if (type == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Object[] objectArray = parameterizedType.getActualTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parameterizedType.actualTypeArguments");
        Object object = ArraysKt.firstOrNull((Object[])objectArray);
        if (!(object instanceof Class)) {
            object = null;
        }
        Class clazz = (Class)object;
        if (clazz == null) {
            return null;
        }
        Class valueType = clazz;
        return this.determineGeneratorForCollectionWithValueType(valueType, collectionType, generatorMappings);
    }

    private final AlchemyGenerator<?> determineGeneratorForCollectionParameter(Parameter collectionParameter, Class<?> collectionType, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        if (this.isMapType(collectionType)) {
            return this.determineGeneratorForMapParameter(collectionParameter, collectionType, generatorMappings);
        }
        Type type = collectionParameter.getParameterizedType();
        if (!(type instanceof ParameterizedType)) {
            type = null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType == null) {
            return null;
        }
        ParameterizedType parameterizedType2 = parameterizedType;
        Object[] objectArray = parameterizedType2.getActualTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parameterizedType.actualTypeArguments");
        Object object = ArraysKt.firstOrNull((Object[])objectArray);
        if (!(object instanceof Class)) {
            object = null;
        }
        Class clazz = (Class)object;
        if (clazz == null) {
            return null;
        }
        Class valueType = clazz;
        return this.determineGeneratorForCollectionWithValueType(valueType, collectionType, generatorMappings);
    }

    static /* bridge */ /* synthetic */ AlchemyGenerator determineGeneratorForCollectionParameter$default(ObjectGenerators objectGenerators, Parameter parameter, Class clazz, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            Class<?> clazz2 = parameter.getType();
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"collectionParameter.type");
            clazz = clazz2;
        }
        return objectGenerators.determineGeneratorForCollectionParameter(parameter, clazz, map);
    }

    private final AlchemyGenerator<?> determineGeneratorForCollectionWithValueType(Class<?> valueType, Class<?> collectionType, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        AlchemyGenerator alchemyGenerator = ObjectGenerators.determineGeneratorFor$default(this, null, null, valueType, generatorMappings, 3, null);
        if (alchemyGenerator == null) {
            return null;
        }
        AlchemyGenerator generator = alchemyGenerator;
        AlchemyGenerator<Integer> generator$iv = NumberGenerators.Companion.integers(10, 100);
        int size = ((Number)generator$iv.get()).intValue();
        if (this.isSetType(collectionType)) {
            return new AlchemyGenerator<Set<? extends Object>>(size, generator){
                final /* synthetic */ int $size;
                final /* synthetic */ AlchemyGenerator $generator;

                @NotNull
                public final Set<Object> get() {
                    int n = this.$size;
                    ArrayList<T> arrayList = new ArrayList<T>(n);
                    int n2 = 0;
                    int n3 = n;
                    while (n2 < n3) {
                        int n4;
                        int n5 = n4 = n2++;
                        ArrayList<T> arrayList2 = arrayList;
                        T t = this.$generator.get();
                        arrayList2.add(t);
                    }
                    return CollectionsKt.toSet((Iterable)arrayList);
                }
                {
                    this.$size = n;
                    this.$generator = alchemyGenerator;
                }
            };
        }
        return new AlchemyGenerator<List<? extends Object>>(size, generator){
            final /* synthetic */ int $size;
            final /* synthetic */ AlchemyGenerator $generator;

            @NotNull
            public final List<Object> get() {
                int n = this.$size;
                ArrayList<T> arrayList = new ArrayList<T>(n);
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int n4;
                    int n5 = n4 = n2++;
                    ArrayList<T> arrayList2 = arrayList;
                    T t = this.$generator.get();
                    arrayList2.add(t);
                }
                return arrayList;
            }
            {
                this.$size = n;
                this.$generator = alchemyGenerator;
            }
        };
    }

    private final AlchemyGenerator<?> determineGeneratorForMapField(Field mapField, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        Type type = mapField.getGenericType();
        if (type == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type type2 = parameterizedType.getActualTypeArguments()[0];
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        Class keyType = (Class)type2;
        Type type3 = parameterizedType.getActualTypeArguments()[1];
        if (type3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        Class valueType = (Class)type3;
        AlchemyGenerator<?> alchemyGenerator = this.determineGeneratorFor(mapField, null, keyType, generatorMappings);
        if (alchemyGenerator == null) {
            return null;
        }
        AlchemyGenerator<?> keyGenerator = alchemyGenerator;
        AlchemyGenerator<?> alchemyGenerator2 = this.determineGeneratorFor(mapField, null, valueType, generatorMappings);
        if (alchemyGenerator2 == null) {
            return null;
        }
        AlchemyGenerator<?> valueGenerator = alchemyGenerator2;
        return new AlchemyGenerator<Map<Object, Object>>(keyGenerator, valueGenerator){
            final /* synthetic */ AlchemyGenerator $keyGenerator;
            final /* synthetic */ AlchemyGenerator $valueGenerator;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Object, Object> get() {
                void var1_1;
                Map map = new LinkedHashMap<K, V>();
                AlchemyGenerator<Integer> generator$iv22 = NumberGenerators.Companion.integers(10, 100);
                int size = ((Number)generator$iv22.get()).intValue();
                int generator$iv22 = 0;
                int n = size;
                while (generator$iv22 < n) {
                    void i;
                    T t;
                    T t2;
                    Map map2 = map;
                    Intrinsics.checkExpressionValueIsNotNull(this.$keyGenerator.get(), (String)"keyGenerator.get()");
                    Intrinsics.checkExpressionValueIsNotNull(this.$valueGenerator.get(), (String)"valueGenerator.get()");
                    map2.put(t2, t);
                    ++i;
                }
                return var1_1;
            }
            {
                this.$keyGenerator = alchemyGenerator;
                this.$valueGenerator = alchemyGenerator2;
            }
        };
    }

    private final AlchemyGenerator<?> determineGeneratorForMapParameter(Parameter mapParameter, Class<?> collectionType, Map<Class<?>, ? extends AlchemyGenerator<?>> generatorMappings) {
        Type type = mapParameter.getParameterizedType();
        if (!(type instanceof ParameterizedType)) {
            type = null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (parameterizedType == null) {
            return null;
        }
        ParameterizedType parameterizedType2 = parameterizedType;
        Type type2 = parameterizedType2.getActualTypeArguments()[0];
        if (!(type2 instanceof Class)) {
            type2 = null;
        }
        Class clazz = (Class)type2;
        if (clazz == null) {
            return null;
        }
        Class keyType = clazz;
        Type type3 = parameterizedType2.getActualTypeArguments()[1];
        if (!(type3 instanceof Class)) {
            type3 = null;
        }
        Class clazz2 = (Class)type3;
        if (clazz2 == null) {
            return null;
        }
        Class valueType = clazz2;
        AlchemyGenerator<?> alchemyGenerator = this.determineGeneratorFor(null, mapParameter, keyType, generatorMappings);
        if (alchemyGenerator == null) {
            return null;
        }
        AlchemyGenerator<?> keyGenerator = alchemyGenerator;
        AlchemyGenerator<?> alchemyGenerator2 = this.determineGeneratorFor(null, null, valueType, generatorMappings);
        if (alchemyGenerator2 == null) {
            return null;
        }
        AlchemyGenerator<?> valueGenerator = alchemyGenerator2;
        return new AlchemyGenerator<Map<Object, Object>>(keyGenerator, valueGenerator){
            final /* synthetic */ AlchemyGenerator $keyGenerator;
            final /* synthetic */ AlchemyGenerator $valueGenerator;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Object, Object> get() {
                void var1_1;
                Map map = new LinkedHashMap<K, V>();
                AlchemyGenerator<Integer> generator$iv22 = NumberGenerators.Companion.integers(10, 100);
                int size = ((Number)generator$iv22.get()).intValue();
                int generator$iv22 = 0;
                int n = size;
                while (generator$iv22 < n) {
                    void i;
                    T t;
                    T t2;
                    Map map2 = map;
                    Intrinsics.checkExpressionValueIsNotNull(this.$keyGenerator.get(), (String)"keyGenerator.get()");
                    Intrinsics.checkExpressionValueIsNotNull(this.$valueGenerator.get(), (String)"valueGenerator.get()");
                    map2.put(t2, t);
                    ++i;
                }
                return var1_1;
            }
            {
                this.$keyGenerator = alchemyGenerator;
                this.$valueGenerator = alchemyGenerator2;
            }
        };
    }

    private final boolean isStatic(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    private final boolean isFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers);
    }

    private final boolean isEnumType(Class<?> typeOfField) {
        return typeOfField.isEnum();
    }

    private final Constructor<?> getFirstAvailableConstructor(@NotNull Class<?> $receiver) {
        Constructor<?> constructor;
        Constructor<?> constructor2;
        Constructor<?> constructor3;
        block3: {
            Constructor<?>[] constructorArray;
            Constructor<?>[] constructorArray2 = $receiver.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(constructorArray2, (String)"this.constructors");
            Constructor<?>[] constructorArray3 = constructorArray = constructorArray2;
            int n = constructorArray3.length;
            for (int i = 0; i < n; ++i) {
                Constructor<?> constructor4;
                Constructor<?> it;
                Constructor<?> constructor5 = it = (constructor4 = constructorArray3[i]);
                Intrinsics.checkExpressionValueIsNotNull(constructor5, (String)"it");
                if (!INSTANCE.hasNoParameters(constructor5)) continue;
                constructor3 = constructor4;
                break block3;
            }
            constructor3 = constructor2 = null;
        }
        if (constructor3 == null) {
            Object[] objectArray = $receiver.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"this.constructors");
            constructor2 = constructor = (Constructor<?>)ArraysKt.firstOrNull((Object[])objectArray);
        }
        if (constructor2 == null) {
            Constructor<?> constructor6 = $receiver.getDeclaredConstructor(new Class[0]);
            constructor = constructor6;
            Intrinsics.checkExpressionValueIsNotNull(constructor6, (String)"this.getDeclaredConstructor()");
        }
        return constructor;
    }

    private final boolean hasNoParameters(@NotNull Constructor<?> $receiver) {
        return $receiver.getParameterCount() == 0;
    }

    private final <T> boolean isPrimitiveClass(Class<T> classOfPojo) {
        if (classOfPojo.isPrimitive()) {
            return true;
        }
        Set otherPrimitives = SetsKt.setOf((Object[])new Class[]{String.class, Date.class, Instant.class});
        return CollectionsKt.contains((Iterable)otherPrimitives, classOfPojo);
    }

    private ObjectGenerators() {
    }

    static {
        ObjectGenerators objectGenerators;
        INSTANCE = objectGenerators = new ObjectGenerators();
        LOG = LoggerFactory.getLogger(ObjectGenerators.class);
        DEFAULT_GENERATOR_MAPPINGS = new ConcurrentHashMap();
        shortGenerator = shortGenerator.1.INSTANCE;
        charGenerator = charGenerator.1.INSTANCE;
        DEFAULT_GENERATOR_MAPPINGS.put(Boolean.TYPE, BooleanGenerators.Companion.booleans());
        DEFAULT_GENERATOR_MAPPINGS.put(Byte.TYPE, BinaryGenerators.Companion.bytes());
        DEFAULT_GENERATOR_MAPPINGS.put(ByteBuffer.class, BinaryGenerators.Companion.byteBuffers(333));
        DEFAULT_GENERATOR_MAPPINGS.put(byte[].class, BinaryGenerators.Companion.binary(333));
        DEFAULT_GENERATOR_MAPPINGS.put(Character.TYPE, charGenerator);
        DEFAULT_GENERATOR_MAPPINGS.put(Character.class, charGenerator);
        DEFAULT_GENERATOR_MAPPINGS.put(Date.class, DateGenerators.Companion.anyTime());
        DEFAULT_GENERATOR_MAPPINGS.put(Double.TYPE, NumberGenerators.Companion.positiveDoubles());
        DEFAULT_GENERATOR_MAPPINGS.put(Integer.TYPE, NumberGenerators.Companion.smallPositiveIntegers());
        DEFAULT_GENERATOR_MAPPINGS.put(Long.TYPE, NumberGenerators.Companion.positiveLongs());
        DEFAULT_GENERATOR_MAPPINGS.put(Short.TYPE, shortGenerator);
        DEFAULT_GENERATOR_MAPPINGS.put(String.class, StringGenerators.Companion.alphabeticStrings());
        DEFAULT_GENERATOR_MAPPINGS.put(Instant.class, TimeGenerators.Companion.anytime());
        DEFAULT_GENERATOR_MAPPINGS.put(URL.class, NetworkGenerators.Companion.httpUrls());
        DEFAULT_GENERATOR_MAPPINGS.put(Boolean.class, BooleanGenerators.Companion.booleans());
        DEFAULT_GENERATOR_MAPPINGS.put(Byte.class, BinaryGenerators.Companion.bytes());
        DEFAULT_GENERATOR_MAPPINGS.put(Byte.class, BinaryGenerators.Companion.bytes());
        DEFAULT_GENERATOR_MAPPINGS.put(Double.class, NumberGenerators.Companion.positiveDoubles());
        DEFAULT_GENERATOR_MAPPINGS.put(Integer.class, NumberGenerators.Companion.smallPositiveIntegers());
        DEFAULT_GENERATOR_MAPPINGS.put(Long.class, NumberGenerators.Companion.positiveLongs());
        DEFAULT_GENERATOR_MAPPINGS.put(Short.class, shortGenerator);
    }

    @Nullable
    public static final /* synthetic */ Object access$tryToInstantiate(ObjectGenerators $this, @NotNull Class $receiver) {
        return $this.tryToInstantiate($receiver);
    }

    public static final /* synthetic */ void access$tryInjectField(ObjectGenerators $this, @NotNull Object instance, @NotNull Field field, @NotNull Map generatorMappings) {
        $this.tryInjectField(instance, field, generatorMappings);
    }
}

