/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.apache.commons.lang3.RandomUtils;
import org.jetbrains.annotations.NotNull;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;

@NonInstantiable
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/BinaryGenerators;", "", "()V", "Companion", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class BinaryGenerators {
    public static final Companion Companion = new Companion(null);

    public BinaryGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate this class");
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<byte[]> binary(int length) throws IllegalArgumentException {
        return Companion.binary(length);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<ByteBuffer> byteBuffers(int size) throws IllegalArgumentException {
        return Companion.byteBuffers(size);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Byte> bytes() {
        return Companion.bytes();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0004H\u0007\u00a8\u0006\r"}, d2={"Ltech/sirwellington/alchemy/generator/BinaryGenerators$Companion;", "", "()V", "binary", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "", "length", "", "byteBuffers", "Ljava/nio/ByteBuffer;", "size", "bytes", "", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AlchemyGenerator<byte[]> binary(int length) throws IllegalArgumentException {
            Checks.checkThat(length >= 0, "length must be >= 0");
            return new AlchemyGenerator<byte[]>(length){
                final /* synthetic */ int $length;

                public final byte[] get() {
                    return RandomUtils.nextBytes((int)this.$length);
                }
                {
                    this.$length = n;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<ByteBuffer> byteBuffers(int size) throws IllegalArgumentException {
            Checks.checkThat(size >= 0, "size must be at least 0");
            AlchemyGenerator<byte[]> delegate = this.binary(size);
            return new AlchemyGenerator<ByteBuffer>(delegate){
                final /* synthetic */ AlchemyGenerator $delegate;

                public final ByteBuffer get() {
                    byte[] binary2 = (byte[])this.$delegate.get();
                    return ByteBuffer.wrap(binary2);
                }
                {
                    this.$delegate = alchemyGenerator;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Byte> bytes() {
            AlchemyGenerator<byte[]> delegate = this.binary(1);
            return new AlchemyGenerator<Byte>(delegate){
                final /* synthetic */ AlchemyGenerator $delegate;

                public final byte get() {
                    byte[] byArray;
                    byte[] byArray2;
                    byte[] array = (byte[])this.$delegate.get();
                    Checks.checkThat(array != null && !((byArray2 = (byArray = array)).length == 0), "no Byte available to return.");
                    return array[0];
                }
                {
                    this.$delegate = alchemyGenerator;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

