/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.Checks;

@NonInstantiable
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/Dates;", "", "()V", "Companion", "alchemy-generator"})
@Internal
public final class Dates {
    public static final Companion Companion = new Companion(null);

    public Dates() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate class");
    }

    @JvmStatic
    @NotNull
    public static final Date now() {
        return Companion.now();
    }

    @JvmStatic
    @NotNull
    public static final Date daysAgo(int days) {
        return Companion.daysAgo(days);
    }

    @JvmStatic
    @NotNull
    public static final Date daysAhead(int days) {
        return Companion.daysAhead(days);
    }

    @JvmStatic
    @NotNull
    public static final Date hoursAgo(int hours) {
        return Companion.hoursAgo(hours);
    }

    @JvmStatic
    @NotNull
    public static final Date hoursAhead(int hours) {
        return Companion.hoursAhead(hours);
    }

    @JvmStatic
    @NotNull
    public static final Date minutesAgo(int minutes) {
        return Companion.minutesAgo(minutes);
    }

    @JvmStatic
    @NotNull
    public static final Date minutesAhead(int minutes) {
        return Companion.minutesAhead(minutes);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isNow(@NotNull Date date, long marginOfErrorMillis) {
        return Companion.isNow(date, marginOfErrorMillis);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isNow(@NotNull Date date) {
        return tech.sirwellington.alchemy.generator.Dates$Companion.isNow$default(Companion, date, 0L, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isNow(@NotNull Instant instant, long marginOfErrorMillis) {
        return Companion.isNow(instant, marginOfErrorMillis);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isNow(@NotNull Instant instant) {
        return tech.sirwellington.alchemy.generator.Dates$Companion.isNow$default(Companion, instant, 0L, 2, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0007\u00a8\u0006\u0016"}, d2={"Ltech/sirwellington/alchemy/generator/Dates$Companion;", "", "()V", "daysAgo", "Ljava/util/Date;", "days", "", "daysAhead", "hoursAgo", "hours", "hoursAhead", "isNow", "", "instant", "Ljava/time/Instant;", "marginOfErrorMillis", "", "date", "minutesAgo", "minutes", "minutesAhead", "now", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Date now() {
            return new Date();
        }

        @JvmStatic
        @NotNull
        public final Date daysAgo(int days) {
            Instant instant = Instant.now().minus(days, ChronoUnit.DAYS);
            return new Date(instant.toEpochMilli());
        }

        @JvmStatic
        @NotNull
        public final Date daysAhead(int days) {
            Instant instant = Instant.now().plus((long)days, ChronoUnit.DAYS);
            return new Date(instant.toEpochMilli());
        }

        @JvmStatic
        @NotNull
        public final Date hoursAgo(int hours) {
            Instant instant = Instant.now().minus(hours, ChronoUnit.HOURS);
            return new Date(instant.toEpochMilli());
        }

        @JvmStatic
        @NotNull
        public final Date hoursAhead(int hours) {
            Instant instant = Instant.now().plus((long)hours, ChronoUnit.HOURS);
            return new Date(instant.toEpochMilli());
        }

        @JvmStatic
        @NotNull
        public final Date minutesAgo(int minutes) {
            Instant instant = Instant.now().minus(minutes, ChronoUnit.MINUTES);
            return new Date(instant.toEpochMilli());
        }

        @JvmStatic
        @NotNull
        public final Date minutesAhead(int minutes) {
            Instant instant = Instant.now().plus((long)minutes, ChronoUnit.MINUTES);
            return new Date(instant.toEpochMilli());
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isNow(@NotNull Date date, long marginOfErrorMillis) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            Date now = this.now();
            Checks.checkNotNull$default(date, null, 2, null);
            Checks.checkThat(marginOfErrorMillis >= 0L, "margin of error must be >= 0");
            long delta = marginOfErrorMillis;
            long timeOfDate = date.getTime();
            long timeOfNow = now.getTime();
            return timeOfDate >= timeOfNow - delta && timeOfDate <= timeOfNow + delta;
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ boolean isNow$default(Companion companion, Date date, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 5L;
            }
            return companion.isNow(date, l);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isNow(@NotNull Date date) {
            return tech.sirwellington.alchemy.generator.Dates$Companion.isNow$default(this, date, 0L, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isNow(@NotNull Instant instant, long marginOfErrorMillis) {
            Intrinsics.checkParameterIsNotNull((Object)instant, (String)"instant");
            Instant now = Instant.now();
            Checks.checkNotNull$default(instant, null, 2, null);
            Checks.checkNotNull$default(now, null, 2, null);
            Checks.checkThat(marginOfErrorMillis >= 0L, "margin of error must be >= 0 ");
            long delta = marginOfErrorMillis;
            long timeOfDate = instant.toEpochMilli();
            long timeOfNow = now.toEpochMilli();
            return timeOfDate >= timeOfNow - delta && timeOfDate <= timeOfNow + delta;
        }

        @JvmStatic
        @JvmOverloads
        public static /* synthetic */ boolean isNow$default(Companion companion, Instant instant, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 5L;
            }
            return companion.isNow(instant, l);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean isNow(@NotNull Instant instant) {
            return tech.sirwellington.alchemy.generator.Dates$Companion.isNow$default(this, instant, 0L, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

