/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.arguments.NonEmpty;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.generator.PeopleGenerators;
import tech.sirwellington.alchemy.generator.StringGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/NetworkGenerators;", "", "()V", "Companion", "alchemy-generator"})
public final class NetworkGenerators {
    private static final Logger LOG;
    private static final URL FALLBACK_URL;
    private static final List<String> VALID_PROTOCOLS;
    public static final Companion Companion;

    private NetworkGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate");
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(NetworkGenerators.class);
        try {
            FALLBACK_URL = new URL("http://google.com");
        }
        catch (MalformedURLException ex) {
            throw (Throwable)new RuntimeException("Could not generate URL", ex);
        }
        VALID_PROTOCOLS = Arrays.asList("http", "https", "ftp", "file", "ssh");
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ URL access$getFALLBACK_URL$cp() {
        return FALLBACK_URL;
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<URL> httpUrls() {
        return Companion.httpUrls();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<URL> httpsUrls() {
        return Companion.httpsUrls();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<URL> urlsWithProtocol(@NonEmpty @NotNull String protocol) {
        return Companion.urlsWithProtocol(protocol);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> ports() {
        return Companion.ports();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<String> ip4Addresses() {
        return Companion.ip4Addresses();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0007J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0007J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\b\b\u0001\u0010\u0013\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/sirwellington/alchemy/generator/NetworkGenerators$Companion;", "", "()V", "FALLBACK_URL", "Ljava/net/URL;", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "VALID_PROTOCOLS", "", "", "", "httpUrls", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "httpsUrls", "ip4Addresses", "ports", "", "urlsWithProtocol", "protocol", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AlchemyGenerator<URL> httpUrls() {
            return this.urlsWithProtocol("http");
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<URL> httpsUrls() {
            return this.urlsWithProtocol("https");
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<URL> urlsWithProtocol(@NonEmpty @NotNull String protocol) {
            Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
            Checks.checkNotEmpty(protocol, "missing protocol");
            String cleanProtocol = StringsKt.replace$default((String)protocol, (String)"://", (String)"", (boolean)false, (int)4, null);
            try {
                new URL(cleanProtocol + "://");
            }
            catch (MalformedURLException ex) {
                throw (Throwable)new IllegalArgumentException("Unknown protocol: " + protocol, ex);
            }
            return new AlchemyGenerator<URL>(cleanProtocol){
                final /* synthetic */ String $cleanProtocol;

                @NotNull
                public final URL get() {
                    URL uRL;
                    String url = this.$cleanProtocol + "://" + StringGenerators.Companion.alphanumericStrings().get() + '.' + PeopleGenerators.Companion.popularEmailDomains().get();
                    try {
                        uRL = new URL(url);
                    }
                    catch (MalformedURLException ex) {
                        NetworkGenerators.access$getLOG$cp().error("Failed to create url from scheme {}", (Object)this.$cleanProtocol, (Object)ex);
                        uRL = NetworkGenerators.access$getFALLBACK_URL$cp();
                    }
                    return uRL;
                }
                {
                    this.$cleanProtocol = string;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> ports() {
            return NumberGenerators.Companion.integers(22, Short.MAX_VALUE);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<String> ip4Addresses() {
            AlchemyGenerator<Integer> integers2 = NumberGenerators.Companion.integers(1, 1000);
            return new AlchemyGenerator<String>(integers2){
                final /* synthetic */ AlchemyGenerator $integers;

                @NotNull
                public final String get() {
                    return "" + (Integer)this.$integers.get() + '.' + (Integer)this.$integers.get() + '.' + (Integer)this.$integers.get() + '.' + (Integer)this.$integers.get();
                }
                {
                    this.$integers = alchemyGenerator;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

