/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.RandomUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BooleanGenerators;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;

@NonInstantiable
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltech/sirwellington/alchemy/generator/NumberGenerators;", "", "()V", "Companion", "alchemy-generator"})
@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class NumberGenerators {
    private static final Logger LOG;
    public static final Companion Companion;

    public NumberGenerators() throws IllegalAccessException {
        throw (Throwable)new IllegalAccessException("cannot instantiate this class");
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(NumberGenerators.class);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> integers(int inclusiveLowerBound, int exclusiveUpperBound) throws IllegalArgumentException {
        return Companion.integers(inclusiveLowerBound, exclusiveUpperBound);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> anyIntegers() {
        return Companion.anyIntegers();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> positiveIntegers() {
        return Companion.positiveIntegers();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> smallPositiveIntegers() {
        return Companion.smallPositiveIntegers();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> negativeIntegers() {
        return Companion.negativeIntegers();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Long> longs(long inclusiveLowerBound, long exclusiveUpperBound) throws IllegalArgumentException {
        return Companion.longs(inclusiveLowerBound, exclusiveUpperBound);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Long> anyLongs() {
        return Companion.anyLongs();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Long> positiveLongs() {
        return Companion.positiveLongs();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Long> smallPositiveLongs() {
        return Companion.smallPositiveLongs();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Double> doubles(double inclusiveLowerBound, double inclusiveUpperBound) throws IllegalArgumentException {
        return Companion.doubles(inclusiveLowerBound, inclusiveUpperBound);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Double> anyDoubles() {
        return Companion.anyDoubles();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Double> positiveDoubles() {
        return Companion.positiveDoubles();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Double> negativeDoubles() {
        return Companion.negativeDoubles();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Double> smallPositiveDoubles() {
        return Companion.smallPositiveDoubles();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Float> floats(float inclusiveLowerBound, float inclusiveUpperBound) throws IllegalArgumentException {
        return Companion.floats(inclusiveLowerBound, inclusiveUpperBound);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Float> anyFloats() {
        return Companion.anyFloats();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Float> positiveFloats() {
        return Companion.positiveFloats();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Float> smallPositiveFloats() {
        return Companion.smallPositiveFloats();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Float> negativeFloats() {
        return Companion.negativeFloats();
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Integer> integersFromFixedList(@NotNull List<Integer> values) {
        return Companion.integersFromFixedList(values);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Double> doublesFromFixedList(@NotNull List<Double> values) {
        return Companion.doublesFromFixedList(values);
    }

    @JvmStatic
    @NotNull
    public static final AlchemyGenerator<Float> floatsFromFixedList(@NotNull List<Float> values) {
        return Companion.floatsFromFixedList(values);
    }

    @JvmStatic
    @Internal
    public static final long safeIncrement$alchemy_generator(long value) {
        return Companion.safeIncrement$alchemy_generator(value);
    }

    @JvmStatic
    @Internal
    public static final long safeDecrement$alchemy_generator(long value) {
        return Companion.safeDecrement$alchemy_generator(value);
    }

    @JvmStatic
    @Internal
    public static final int safeIncrement$alchemy_generator(int value) {
        return Companion.safeIncrement$alchemy_generator(value);
    }

    @JvmStatic
    @Internal
    public static final int safeDecrement$alchemy_generator(int value) {
        return Companion.safeDecrement$alchemy_generator(value);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0007J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0007J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0007J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0007J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0007J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0007J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0007J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0007J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b$J\u0015\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\f2\u0006\u0010#\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b&J\u0015\u0010%\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0007J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0007J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ltech/sirwellington/alchemy/generator/NumberGenerators$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "anyDoubles", "Ltech/sirwellington/alchemy/generator/AlchemyGenerator;", "", "anyFloats", "", "anyIntegers", "", "anyLongs", "", "doubles", "inclusiveLowerBound", "inclusiveUpperBound", "doublesFromFixedList", "values", "", "floats", "floatsFromFixedList", "integers", "exclusiveUpperBound", "integersFromFixedList", "longs", "negativeDoubles", "negativeFloats", "negativeIntegers", "positiveDoubles", "positiveFloats", "positiveIntegers", "positiveLongs", "safeDecrement", "value", "safeDecrement$alchemy_generator", "safeIncrement", "safeIncrement$alchemy_generator", "smallPositiveDoubles", "smallPositiveFloats", "smallPositiveIntegers", "smallPositiveLongs", "alchemy-generator"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> integers(int inclusiveLowerBound, int exclusiveUpperBound) throws IllegalArgumentException {
            Checks.checkThat(inclusiveLowerBound < exclusiveUpperBound, "Lower Bound must be < Upper Bound");
            boolean isNegativeLowerBound = inclusiveLowerBound < 0;
            boolean isNegativeUpperBound = exclusiveUpperBound <= 0;
            return new AlchemyGenerator<Integer>(isNegativeLowerBound, isNegativeUpperBound, exclusiveUpperBound, inclusiveLowerBound){
                final /* synthetic */ boolean $isNegativeLowerBound;
                final /* synthetic */ boolean $isNegativeUpperBound;
                final /* synthetic */ int $exclusiveUpperBound;
                final /* synthetic */ int $inclusiveLowerBound;

                public final int get() {
                    int n;
                    if (this.$isNegativeLowerBound && this.$isNegativeUpperBound) {
                        int min = -this.$exclusiveUpperBound;
                        int max = this.$inclusiveLowerBound == Integer.MIN_VALUE ? Integer.MAX_VALUE : -this.$inclusiveLowerBound;
                        int minAdjustedForInclusivity = NumberGenerators.Companion.safeIncrement$alchemy_generator(min);
                        int maxAdjustedForInclusivity = NumberGenerators.Companion.safeIncrement$alchemy_generator(max);
                        n = -RandomUtils.nextInt((int)minAdjustedForInclusivity, (int)maxAdjustedForInclusivity);
                    } else if (this.$isNegativeLowerBound) {
                        Boolean shouldProduceNegative;
                        Boolean bl = shouldProduceNegative = BooleanGenerators.Companion.booleans().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"shouldProduceNegative");
                        if (bl.booleanValue()) {
                            int max = this.$inclusiveLowerBound == Integer.MIN_VALUE ? Integer.MAX_VALUE : -this.$inclusiveLowerBound;
                            int maxAdjustedForInclusivity = NumberGenerators.Companion.safeIncrement$alchemy_generator(max);
                            n = -RandomUtils.nextInt((int)0, (int)maxAdjustedForInclusivity);
                        } else {
                            n = RandomUtils.nextInt((int)0, (int)this.$exclusiveUpperBound);
                        }
                    } else {
                        n = RandomUtils.nextInt((int)this.$inclusiveLowerBound, (int)this.$exclusiveUpperBound);
                    }
                    return n;
                }
                {
                    this.$isNegativeLowerBound = bl;
                    this.$isNegativeUpperBound = bl2;
                    this.$exclusiveUpperBound = n;
                    this.$inclusiveLowerBound = n2;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> anyIntegers() {
            return this.integers(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> positiveIntegers() {
            return this.integers(1, Integer.MAX_VALUE);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> smallPositiveIntegers() {
            return this.integers(1, 1000);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> negativeIntegers() {
            return negativeIntegers.1.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Long> longs(long inclusiveLowerBound, long exclusiveUpperBound) throws IllegalArgumentException {
            Checks.checkThat(inclusiveLowerBound < exclusiveUpperBound, "Lower Bound must be < Upper Bound");
            boolean negativeLowerBound = inclusiveLowerBound < 0L;
            boolean negativeUpperBound = exclusiveUpperBound <= 0L;
            return new AlchemyGenerator<Long>(negativeLowerBound, negativeUpperBound, exclusiveUpperBound, inclusiveLowerBound){
                final /* synthetic */ boolean $negativeLowerBound;
                final /* synthetic */ boolean $negativeUpperBound;
                final /* synthetic */ long $exclusiveUpperBound;
                final /* synthetic */ long $inclusiveLowerBound;

                public final long get() {
                    long l;
                    if (this.$negativeLowerBound && this.$negativeUpperBound) {
                        long min = -this.$exclusiveUpperBound;
                        long max = this.$inclusiveLowerBound == Long.MIN_VALUE ? Long.MAX_VALUE : -this.$inclusiveLowerBound;
                        long minAdjustedForInclusivity = NumberGenerators.Companion.safeIncrement$alchemy_generator(min);
                        long maxAdjustedForInclusivity = NumberGenerators.Companion.safeIncrement$alchemy_generator(max);
                        l = -RandomUtils.nextLong((long)minAdjustedForInclusivity, (long)maxAdjustedForInclusivity);
                    } else if (this.$negativeLowerBound) {
                        Boolean shouldProduceNegative;
                        Boolean bl = shouldProduceNegative = BooleanGenerators.Companion.booleans().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"shouldProduceNegative");
                        if (bl.booleanValue()) {
                            long min = 0L;
                            long max = this.$inclusiveLowerBound == Long.MIN_VALUE ? Long.MAX_VALUE : -this.$inclusiveLowerBound;
                            long maxAdjustedForInclusivity = NumberGenerators.Companion.safeIncrement$alchemy_generator(max);
                            l = -RandomUtils.nextLong((long)min, (long)maxAdjustedForInclusivity);
                        } else {
                            l = RandomUtils.nextLong((long)0L, (long)this.$exclusiveUpperBound);
                        }
                    } else {
                        l = RandomUtils.nextLong((long)this.$inclusiveLowerBound, (long)this.$exclusiveUpperBound);
                    }
                    return l;
                }
                {
                    this.$negativeLowerBound = bl;
                    this.$negativeUpperBound = bl2;
                    this.$exclusiveUpperBound = l;
                    this.$inclusiveLowerBound = l2;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Long> anyLongs() {
            return this.longs(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Long> positiveLongs() {
            return this.longs(1L, Long.MAX_VALUE);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Long> smallPositiveLongs() {
            return this.longs(1L, 10000L);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Double> doubles(double inclusiveLowerBound, double inclusiveUpperBound) throws IllegalArgumentException {
            Checks.checkThat(inclusiveLowerBound <= inclusiveUpperBound, "Upper Bound must be greater than Lower Bound");
            boolean negativeLowerBound = inclusiveLowerBound < 0.0;
            boolean negativeUpperBound = inclusiveUpperBound < 0.0;
            return new AlchemyGenerator<Double>(negativeLowerBound, negativeUpperBound, inclusiveUpperBound, inclusiveLowerBound){
                final /* synthetic */ boolean $negativeLowerBound;
                final /* synthetic */ boolean $negativeUpperBound;
                final /* synthetic */ double $inclusiveUpperBound;
                final /* synthetic */ double $inclusiveLowerBound;

                public final double get() {
                    double d;
                    if (this.$negativeLowerBound && this.$negativeUpperBound) {
                        d = -RandomUtils.nextDouble((double)(-this.$inclusiveUpperBound), (double)(-this.$inclusiveLowerBound));
                    } else if (this.$negativeLowerBound) {
                        Boolean shouldProduceNegative;
                        Boolean bl = shouldProduceNegative = BooleanGenerators.Companion.booleans().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"shouldProduceNegative");
                        d = bl.booleanValue() ? -RandomUtils.nextDouble((double)0.0, (double)(-this.$inclusiveLowerBound)) : RandomUtils.nextDouble((double)0.0, (double)this.$inclusiveUpperBound);
                    } else {
                        d = RandomUtils.nextDouble((double)this.$inclusiveLowerBound, (double)this.$inclusiveUpperBound);
                    }
                    return d;
                }
                {
                    this.$negativeLowerBound = bl;
                    this.$negativeUpperBound = bl2;
                    this.$inclusiveUpperBound = d;
                    this.$inclusiveLowerBound = d2;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Double> anyDoubles() {
            return this.doubles(-DoubleCompanionObject.INSTANCE.getMAX_VALUE(), DoubleCompanionObject.INSTANCE.getMAX_VALUE());
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Double> positiveDoubles() {
            return this.doubles(0.1, DoubleCompanionObject.INSTANCE.getMAX_VALUE());
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Double> negativeDoubles() {
            return this.doubles(-DoubleCompanionObject.INSTANCE.getMAX_VALUE(), -0.01);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Double> smallPositiveDoubles() {
            return this.doubles(0.1, 1000.0);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Float> floats(float inclusiveLowerBound, float inclusiveUpperBound) throws IllegalArgumentException {
            Checks.checkThat(inclusiveLowerBound <= inclusiveUpperBound, "Upper Bound must be greater than Lower Bound");
            AlchemyGenerator<Double> doubleGenerator = this.doubles(inclusiveLowerBound, inclusiveUpperBound);
            return new AlchemyGenerator<Float>(doubleGenerator){
                final /* synthetic */ AlchemyGenerator $doubleGenerator;

                public final float get() {
                    return (float)((Number)this.$doubleGenerator.get()).doubleValue();
                }
                {
                    this.$doubleGenerator = alchemyGenerator;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Float> anyFloats() {
            return this.floats(-FloatCompanionObject.INSTANCE.getMAX_VALUE(), FloatCompanionObject.INSTANCE.getMAX_VALUE());
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Float> positiveFloats() {
            return this.floats(0.1f, FloatCompanionObject.INSTANCE.getMAX_VALUE());
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Float> smallPositiveFloats() {
            return this.floats(0.1f, 1000.0f);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Float> negativeFloats() {
            return this.floats(-FloatCompanionObject.INSTANCE.getMAX_VALUE(), -0.01f);
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Integer> integersFromFixedList(@NotNull List<Integer> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Collection collection = values;
            Checks.checkThat(!collection.isEmpty(), "No values specified");
            return new AlchemyGenerator<Integer>(values){
                final /* synthetic */ List $values;

                public final int get() {
                    Integer index;
                    Integer n = index = NumberGenerators.Companion.integers(0, this.$values.size()).get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"index");
                    return ((Number)this.$values.get(n)).intValue();
                }
                {
                    this.$values = list;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Double> doublesFromFixedList(@NotNull List<Double> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Collection collection = values;
            Checks.checkThat(!collection.isEmpty(), "No values specified");
            return new AlchemyGenerator<Double>(values){
                final /* synthetic */ List $values;

                public final double get() {
                    Integer index;
                    Integer n = index = NumberGenerators.Companion.integers(0, this.$values.size()).get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"index");
                    return ((Number)this.$values.get(n)).doubleValue();
                }
                {
                    this.$values = list;
                }
            };
        }

        @JvmStatic
        @NotNull
        public final AlchemyGenerator<Float> floatsFromFixedList(@NotNull List<Float> values) {
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Collection collection = values;
            Checks.checkThat(!collection.isEmpty(), "No values specified");
            return new AlchemyGenerator<Float>(values){
                final /* synthetic */ List $values;

                public final float get() {
                    Integer index;
                    Integer n = index = NumberGenerators.Companion.integers(0, this.$values.size()).get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"index");
                    return ((Number)this.$values.get(n)).floatValue();
                }
                {
                    this.$values = list;
                }
            };
        }

        @JvmStatic
        @Internal
        public final long safeIncrement$alchemy_generator(long value) {
            return value == Long.MAX_VALUE ? value : value + 1L;
        }

        @JvmStatic
        @Internal
        public final long safeDecrement$alchemy_generator(long value) {
            return value == Long.MIN_VALUE ? value : value - 1L;
        }

        @JvmStatic
        @Internal
        public final int safeIncrement$alchemy_generator(int value) {
            return value == Integer.MAX_VALUE ? value : value + 1;
        }

        @JvmStatic
        @Internal
        public final int safeDecrement$alchemy_generator(int value) {
            return value == Integer.MIN_VALUE ? value : value - 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

