/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.util.function.Supplier;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.runners.util.FrameworkUsageValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.test.junit.runners.DontRepeat;
import tech.sirwellington.alchemy.test.junit.runners.InitMocks;
import tech.sirwellington.alchemy.test.junit.runners.Repeat;
import tech.sirwellington.alchemy.test.junit.runners.RepeatStatement;
import tech.sirwellington.alchemy.test.junit.runners.TestClassInjectors;

public class AlchemyTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AlchemyTestRunner.class);
    private boolean shouldInitMocks = this.shouldInitMockitoMocks();

    public AlchemyTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement withBefores(FrameworkMethod method, final Object target, Statement statement) {
        final Statement superStatement = super.withBefores(method, target, statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                if (AlchemyTestRunner.this.shouldInitMocks) {
                    MockitoAnnotations.initMocks((Object)target);
                }
                TestClassInjectors.populateGeneratedFields(AlchemyTestRunner.this.getTestClass(), target);
                superStatement.evaluate();
            }
        };
    }

    protected Statement methodBlock(FrameworkMethod method) {
        int timesToRun = this.determineTimesToRun(method);
        Supplier<Statement> statementFactory = () -> super.methodBlock(method);
        return new RepeatStatement(timesToRun, statementFactory, method);
    }

    public void run(RunNotifier notifier) {
        if (this.shouldInitMocks) {
            notifier.addListener((RunListener)new FrameworkUsageValidator(notifier));
        }
        super.run(notifier);
    }

    private int determineTimesToRun(FrameworkMethod method) {
        DontRepeat dontRepeatAnnotation = (DontRepeat)method.getAnnotation(DontRepeat.class);
        if (dontRepeatAnnotation != null) {
            return 1;
        }
        Repeat repeatAnnotationOnMethod = (Repeat)method.getAnnotation(Repeat.class);
        if (repeatAnnotationOnMethod != null) {
            int value = repeatAnnotationOnMethod.value();
            if (value <= 0) {
                LOG.error(method.getName() + " annotated with a negative @Times. Defaulting to 1");
                value = 1;
            }
            return value;
        }
        Repeat repeatAnnotationOnClass = (Repeat)this.getTestClass().getAnnotation(Repeat.class);
        if (repeatAnnotationOnClass != null) {
            int value = repeatAnnotationOnClass.value();
            if (value <= 0) {
                LOG.error(this.getTestClass().getName() + " annotated with a negative @Times. Defaulting to 1");
                value = 1;
            }
            return value;
        }
        return 1;
    }

    private boolean shouldInitMockitoMocks() {
        TestClass testClass = this.getTestClass();
        InitMocks initMocks = (InitMocks)testClass.getAnnotation(InitMocks.class);
        if (initMocks != null) {
            return initMocks.value();
        }
        return true;
    }
}

