/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateDouble {
    public Type value() default Type.POSITIVE;

    public double min() default 0.0;

    public double max() default 0.0;

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<Double> createGeneratorFor(GenerateDouble annotation) {
            Checks.Internal.checkNotNull(annotation, "missing annotation");
            Type type = annotation.value();
            Checks.Internal.checkNotNull((Object)type, "@GenerateDouble missing value");
            if (type == Type.RANGE) {
                double max;
                double min = annotation.min();
                Checks.Internal.checkThat(min < (max = annotation.max()), "@GenerateDouble: min must be less than max");
                return NumberGenerators.doubles((double)min, (double)max);
            }
            switch (type) {
                case POSITIVE: {
                    return NumberGenerators.positiveDoubles();
                }
                case NEGATIVE: {
                    return NumberGenerators.doubles((double)-1.7976931348623157E308, (double)-1.7976931348623157E308);
                }
            }
            return NumberGenerators.doubles((double)-1.7976931348623157E308, (double)Double.MAX_VALUE);
        }
    }

    public static enum Type {
        POSITIVE,
        NEGATIVE,
        ANY,
        RANGE;

    }
}

