/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateLong {
    public Type value() default Type.POSITIVE;

    public long min() default 0L;

    public long max() default 0L;

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<Long> createGeneratorFor(GenerateLong annotation) {
            Checks.Internal.checkNotNull(annotation, "missing annotation");
            Type type = annotation.value();
            Checks.Internal.checkNotNull((Object)type, "@GenerateLong missing value");
            if (type == Type.RANGE) {
                long max;
                long min = annotation.min();
                Checks.Internal.checkThat(min < (max = annotation.max()), "@GenerateLong: min must be less than max");
                return NumberGenerators.longs((long)min, (long)max);
            }
            switch (type) {
                case POSITIVE: {
                    return NumberGenerators.positiveLongs();
                }
                case NEGATIVE: {
                    return NumberGenerators.longs((long)Long.MIN_VALUE, (long)0L);
                }
            }
            return NumberGenerators.longs((long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
        }
    }

    public static enum Type {
        POSITIVE,
        NEGATIVE,
        ANY,
        RANGE;

    }
}

