/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.StringGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateString {
    public Type value() default Type.ALPHABETIC;

    public int length() default 10;

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<String> createGeneratorFor(GenerateString annotation) {
            Checks.Internal.checkNotNull(annotation, "annotation is missing");
            int length = annotation.length();
            Checks.Internal.checkThat(length > 0, "Invalid @GenerateString use, length must be positive");
            Type type = annotation.value();
            Checks.Internal.checkNotNull((Object)type, "@GenerateString Annotation missing type");
            switch (type) {
                case ALPHABETIC: {
                    return StringGenerators.alphabeticString((int)length);
                }
                case ALPHANUMERIC: {
                    return StringGenerators.alphanumericString((int)length);
                }
                case HEXADECIMAL: {
                    return StringGenerators.hexadecimalString((int)length);
                }
                case UUID: {
                    return StringGenerators.uuids;
                }
            }
            return StringGenerators.alphabeticString((int)length);
        }
    }

    public static enum Type {
        ALPHABETIC,
        ALPHANUMERIC,
        HEXADECIMAL,
        UUID;

    }
}

