/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.reflect.Field;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.test.Checks;
import tech.sirwellington.alchemy.test.junit.runners.GenerateDate;
import tech.sirwellington.alchemy.test.junit.runners.GenerateDouble;
import tech.sirwellington.alchemy.test.junit.runners.GenerateEnum;
import tech.sirwellington.alchemy.test.junit.runners.GenerateInstant;
import tech.sirwellington.alchemy.test.junit.runners.GenerateInteger;
import tech.sirwellington.alchemy.test.junit.runners.GenerateList;
import tech.sirwellington.alchemy.test.junit.runners.GenerateLong;
import tech.sirwellington.alchemy.test.junit.runners.GeneratePojo;
import tech.sirwellington.alchemy.test.junit.runners.GenerateString;
import tech.sirwellington.alchemy.test.junit.runners.GenerateURL;

@NonInstantiable
@Internal
final class TestClassInjectors {
    private static final Logger LOG = LoggerFactory.getLogger(TestClassInjectors.class);

    TestClassInjectors() {
    }

    static void populateGeneratedFields(TestClass testClass, Object target) throws IllegalArgumentException, IllegalAccessException {
        List stringGeneratedFields = testClass.getAnnotatedFields(GenerateString.class);
        for (Object field : stringGeneratedFields) {
            TestClassInjectors.inflateString((FrameworkField)field, target);
        }
        List integerGeneratedFields = testClass.getAnnotatedFields(GenerateInteger.class);
        for (Object field : integerGeneratedFields) {
            TestClassInjectors.inflateInteger((FrameworkField)field, target);
        }
        List longGeneratedFields = testClass.getAnnotatedFields(GenerateLong.class);
        for (Object field : longGeneratedFields) {
            TestClassInjectors.inflateLong((FrameworkField)field, target);
        }
        List doubleGeneratedFields = testClass.getAnnotatedFields(GenerateDouble.class);
        for (Object field : doubleGeneratedFields) {
            TestClassInjectors.inflateDouble((FrameworkField)field, target);
        }
        List dateGeneratedFields = testClass.getAnnotatedFields(GenerateDate.class);
        for (Object field : dateGeneratedFields) {
            TestClassInjectors.inflateDate((FrameworkField)field, target);
        }
        List instantGeneratedFields = testClass.getAnnotatedFields(GenerateInstant.class);
        for (Object field : instantGeneratedFields) {
            TestClassInjectors.inflateInstant((FrameworkField)field, target);
        }
        List urlGeneratedFields = testClass.getAnnotatedFields(GenerateURL.class);
        for (Object field : urlGeneratedFields) {
            TestClassInjectors.inflateUrl((FrameworkField)field, target);
        }
        List pojoGeneratedFields = testClass.getAnnotatedFields(GeneratePojo.class);
        for (Object field : pojoGeneratedFields) {
            TestClassInjectors.inflatePojo((FrameworkField)field, target);
        }
        List enumGeneratedFields = testClass.getAnnotatedFields(GenerateEnum.class);
        for (FrameworkField field : enumGeneratedFields) {
            TestClassInjectors.inflateEnum(field, target);
        }
        List listGeneratedfields = testClass.getAnnotatedFields(GenerateList.class);
        for (FrameworkField field : listGeneratedfields) {
            TestClassInjectors.inflateList(field, target);
        }
    }

    private static void inflateString(FrameworkField field, Object target) throws IllegalArgumentException, IllegalAccessException {
        GenerateString annotation = (GenerateString)field.getAnnotation(GenerateString.class);
        Checks.Internal.checkNotNull(annotation, "missing annotation");
        AlchemyGenerator<String> generator = GenerateString.Values.createGeneratorFor(annotation);
        String value = (String)generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateInteger(FrameworkField field, Object target) throws IllegalArgumentException, IllegalAccessException {
        GenerateInteger annotation = (GenerateInteger)field.getAnnotation(GenerateInteger.class);
        Checks.Internal.checkNotNull(annotation, "missing annotation");
        AlchemyGenerator<Integer> generator = GenerateInteger.Values.createGeneratorFor(annotation);
        Integer value = (Integer)generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateLong(FrameworkField field, Object target) throws IllegalAccessException {
        GenerateLong annotation = (GenerateLong)field.getAnnotation(GenerateLong.class);
        Checks.Internal.checkNotNull(annotation, "missing annotation");
        AlchemyGenerator<Long> generator = GenerateLong.Values.createGeneratorFor(annotation);
        Long value = (Long)generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateDouble(FrameworkField field, Object target) throws IllegalAccessException {
        GenerateDouble annotation = (GenerateDouble)field.getAnnotation(GenerateDouble.class);
        Checks.Internal.checkNotNull(annotation, "missing annotation");
        AlchemyGenerator<Double> generator = GenerateDouble.Values.createGeneratorFor(annotation);
        Double value = (Double)generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateDate(FrameworkField field, Object target) throws IllegalArgumentException, IllegalAccessException {
        GenerateDate annotation = (GenerateDate)field.getAnnotation(GenerateDate.class);
        Checks.Internal.checkNotNull(annotation, "missing annotation");
        AlchemyGenerator<Date> generator = GenerateDate.Values.createGeneratorFor(annotation);
        Date value = (Date)generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateInstant(FrameworkField field, Object target) throws IllegalArgumentException, IllegalAccessException {
        GenerateInstant annotation = (GenerateInstant)field.getAnnotation(GenerateInstant.class);
        Checks.Internal.checkNotNull(annotation, "missing annotation");
        AlchemyGenerator<Instant> generator = GenerateInstant.Values.createGeneratorFor(annotation);
        Instant value = (Instant)generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateUrl(FrameworkField field, Object target) throws IllegalAccessException {
        GenerateURL annotation = (GenerateURL)field.getAnnotation(GenerateURL.class);
        Checks.Internal.checkNotNull(annotation, "missing annotation");
        AlchemyGenerator<URL> generator = GenerateURL.Values.createGeneratorFor(annotation);
        URL value = (URL)generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflatePojo(FrameworkField field, Object target) throws IllegalArgumentException, IllegalAccessException {
        Class typeOfPojo = field.getType();
        GeneratePojo annotation = (GeneratePojo)field.getAnnotation(GeneratePojo.class);
        AlchemyGenerator generator = GeneratePojo.Values.createGeneratorFor(annotation, typeOfPojo);
        Object value = generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateEnum(FrameworkField field, Object target) throws IllegalArgumentException, IllegalAccessException {
        Class typeOfField = field.getType();
        Checks.Internal.checkThat(typeOfField.isEnum(), "@GenerateEnum can only be used on Enum Types");
        Class typeOfEnum = typeOfField;
        GenerateEnum annotation = (GenerateEnum)field.getAnnotation(GenerateEnum.class);
        AlchemyGenerator generator = GenerateEnum.Values.createGeneratorFor(annotation, typeOfEnum);
        Object value = generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    private static void inflateList(FrameworkField field, Object target) throws IllegalArgumentException, IllegalAccessException {
        Class typeOfField = field.getType();
        Checks.Internal.checkThat(List.class.isAssignableFrom(typeOfField), "@GenerateList can only be used on List Types");
        GenerateList annotation = (GenerateList)field.getAnnotation(GenerateList.class);
        AlchemyGenerator<List<?>> generator = GenerateList.Values.createGeneratorFor(annotation);
        Object value = generator.get();
        TestClassInjectors.inflate(field, target, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void inflate(FrameworkField field, Object target, Object value) throws IllegalArgumentException, IllegalAccessException {
        Field javaField = field.getField();
        boolean originalAccessibility = javaField.isAccessible();
        try {
            javaField.setAccessible(true);
            javaField.set(target, value);
        }
        finally {
            javaField.setAccessible(originalAccessibility);
        }
    }
}

