/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.concurrency.Immutable;
import tech.sirwellington.alchemy.test.Checks;
import tech.sirwellington.alchemy.test.junit.runners.Provider;

@Internal
@Immutable
class RepeatStatement
extends Statement {
    private final int timesToRepeat;
    private final Provider<Statement> statementFactory;
    private final FrameworkMethod method;

    public RepeatStatement(int timesToRepeat, Provider<Statement> statementFactory, FrameworkMethod method) {
        Checks.Internal.checkThat(timesToRepeat > 0, "timesToRepeat must be > 0");
        Checks.Internal.checkNotNull(statementFactory);
        Checks.Internal.checkNotNull(statementFactory.get(), "statementFactory returned null");
        Checks.Internal.checkNotNull(method);
        this.timesToRepeat = timesToRepeat;
        this.statementFactory = statementFactory;
        this.method = method;
    }

    public void evaluate() throws Throwable {
        System.out.println();
        String methodName = this.method.getName();
        System.out.println(methodName + "()");
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.timesToRepeat; ++i) {
            Statement delegateStatement = this.statementFactory.get();
            Checks.Internal.checkNotNull(delegateStatement, "statementFactory returned null Statement");
            delegateStatement.evaluate();
        }
        long end = System.currentTimeMillis();
        System.out.printf("  Duration: %dms\n", end - start);
        if (this.timesToRepeat > 1) {
            System.out.printf("  Runs: %d\n", this.timesToRepeat);
        }
    }

    public String toString() {
        return "RepeatStatement{timesToRepeat=" + this.timesToRepeat + ", statementFactory=" + this.statementFactory + ", method=" + this.method + '}';
    }
}

