/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.NumberGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateInteger {
    public Type value() default Type.POSITIVE;

    public int min() default 0;

    public int max() default 0;

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<Integer> createGeneratorFor(GenerateInteger annotation) {
            Checks.Internal.checkNotNull(annotation, "missing annotation");
            Type type = annotation.value();
            Checks.Internal.checkNotNull((Object)type, "@GenerateInteger missing value");
            if (type == Type.RANGE) {
                int max;
                int min = annotation.min();
                Checks.Internal.checkThat(min < (max = annotation.max()), "@GenerateInteger: min must be less than max");
                return NumberGenerators.integers((int)min, (int)max);
            }
            switch (type) {
                case POSITIVE: {
                    return NumberGenerators.positiveIntegers();
                }
                case NEGATIVE: {
                    return NumberGenerators.negativeIntegers();
                }
            }
            return NumberGenerators.integers((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
        }
    }

    public static enum Type {
        POSITIVE,
        NEGATIVE,
        ANY,
        RANGE;

    }
}

