/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class BoxTrace
extends AbstractTrace {
    private Object[] x;
    private double[] y;

    private BoxTrace(BoxBuilder builder) {
        super(builder);
        this.x = builder.x;
        this.y = builder.y;
    }

    public static BoxBuilder builder(Object[] x, double[] y) {
        return new BoxBuilder(x, y);
    }

    public static BoxBuilder builder(CategoricalColumn x, NumberColumn y) {
        return new BoxBuilder(x, y);
    }

    public static BoxBuilder builder(double[] x, double[] y) {
        Object[] xObjs = new Double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xObjs[i] = x[i];
        }
        return new BoxBuilder(xObjs, y);
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext(i));
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        context.put("y", Utils.dataAsString(this.y));
        context.put("x", Utils.dataAsString(this.x));
        return context;
    }

    public static class BoxBuilder
    extends TraceBuilder {
        private static final String type = "box";
        private Object[] x;
        private double[] y;

        BoxBuilder(Object[] x, double[] y) {
            this.x = x;
            this.y = y;
        }

        BoxBuilder(CategoricalColumn x, NumberColumn y) {
            this.x = BoxBuilder.columnToStringArray((Column)x);
            this.y = y.asDoubleArray();
        }

        public BoxTrace build() {
            return new BoxTrace(this);
        }

        @Override
        protected String getType() {
            return type;
        }
    }
}

