/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class Line
extends Component {
    private final String color;
    private final double width;
    private final double smoothing;
    private final Shape shape;
    private final String dash;
    private final boolean simplify;

    private Line(LineBuilder builder) {
        this.color = builder.color;
        this.shape = builder.shape;
        this.smoothing = builder.smoothing;
        this.dash = builder.dash;
        this.simplify = builder.simplify;
        this.width = builder.width;
    }

    public Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("color", this.color);
        context.put("width", this.width);
        context.put("shape", (Object)this.shape);
        context.put("smoothing", this.smoothing);
        context.put("dash", this.dash);
        context.put("simplify", this.simplify);
        return context;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("line_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    public String getColor() {
        return this.color;
    }

    public double getWidth() {
        return this.width;
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getDash() {
        return this.dash;
    }

    public boolean isSimplify() {
        return this.simplify;
    }

    public static LineBuilder builder() {
        return new LineBuilder();
    }

    public static class LineBuilder {
        private String color = "gray";
        private double width = 2.0;
        private double smoothing = 1.0;
        private Shape shape = Shape.LINEAR;
        private String dash = "solid";
        private boolean simplify = true;

        public LineBuilder color(String color) {
            this.color = color;
            return this;
        }

        public LineBuilder width(double width) {
            Preconditions.checkArgument((width >= 0.0 ? 1 : 0) != 0);
            this.width = width;
            return this;
        }

        public LineBuilder smoothing(double smoothing) {
            Preconditions.checkArgument((smoothing >= 0.0 && smoothing <= 1.3 ? 1 : 0) != 0);
            this.smoothing = smoothing;
            return this;
        }

        public LineBuilder dash(String dash) {
            this.dash = dash;
            return this;
        }

        public LineBuilder simplify(boolean b) {
            this.simplify = b;
            return this;
        }

        public LineBuilder shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        public Line build() {
            return new Line(this);
        }
    }

    public static enum Shape {
        LINEAR("linear"),
        SPLINE("spline"),
        HV("hv"),
        VH("vh"),
        HVH("hvh"),
        VHV("vhv");

        private final String value;

        private Shape(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

