package tech.tablesaw.plotly.components.change;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import tech.tablesaw.plotly.components.Component;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public abstract class Change extends Component {

    //private static final ChangeLine DEFAULT_CHANGE_LINE = new LineBuilder().build();

    private final ChangeLine changeLine;
    private final String fillColor;

    @Override
    public String asJavascript() {
        Writer writer = new StringWriter();
        PebbleTemplate compiledTemplate;

        try {
            compiledTemplate = engine.getTemplate("change_template.html");

            compiledTemplate.evaluate(writer, getContext());
        } catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    Change(ChangeBuilder builder) {
        this.changeLine = builder.changeLine;
        this.fillColor = builder.fillColor;
    }

    private Map<String, Object> getContext() {
        Map<String, Object> context = new HashMap<>();
        if (changeLine != null) context.put("changeLine", changeLine);
        if (fillColor != null) context.put("fillColor", fillColor);
        return context;
    }

    public static class ChangeBuilder {

        protected String fillColor;
        protected ChangeLine changeLine;

        public ChangeBuilder fillColor(String color) {
            this.fillColor = color;
            return this;
        }

        public ChangeBuilder changeLine(ChangeLine line) {
            this.changeLine = line;
            return this;
        }
    }
}
