/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Background;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxPareto
extends FxBuilder {
    public static BarChart<String, Number> chart(String title, StringColumn x, NumberColumn y) {
        CategoryAxis xAxis = new CategoryAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel(x.name());
        yAxis.setLabel(y.name());
        Table t = Table.create((String)"", (Column[])new Column[]{x, y});
        t = t.sortDescendingOn(new String[]{y.name()});
        BarChart bar = new BarChart((Axis)xAxis, (Axis)yAxis);
        bar.setTitle(title);
        ArrayList<XYChart.Data> d2 = new ArrayList<XYChart.Data>(x.size());
        for (int i = 0; i < x.size(); ++i) {
            d2.add(new XYChart.Data((Object)t.stringColumn(0).get(i), (Object)t.nCol(1).get(i)));
        }
        XYChart.Series series1 = new XYChart.Series(FXCollections.observableList(d2));
        series1.setName(y.name());
        bar.setLegendVisible(false);
        bar.setCategoryGap(0.0);
        bar.setBarGap(0.1);
        bar.setBackground(Background.EMPTY);
        bar.setVerticalGridLinesVisible(false);
        bar.getData().add((Object)series1);
        return bar;
    }

    public static BarChart<String, Number> chart(String title, NumberColumn categoryColumn, NumberColumn numberColumn) {
        Table t = Table.create((String)"", (Column[])new Column[]{categoryColumn, numberColumn});
        t = t.sortDescendingOn(new String[]{numberColumn.name()});
        CategoryAxis categoryAxis = FxPareto.getCategoryAxis((Column)t.stringColumn(0));
        NumberAxis numberAxis = FxPareto.getNumberAxis(t.numberColumn(1));
        BarChart<String, Number> barChart = FxPareto.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)categoryColumn.getString(i), (Object)numberColumn.get(i)));
        }
        barChart.getData().add(FxPareto.getSeries(numberColumn, data));
        return barChart;
    }
}

