/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class FxTable
extends TableView<Integer> {
    private Table tableData;

    private FxTable() {
    }

    private static FxTable build() {
        return new FxTable();
    }

    public static FxTable build(Table table) {
        FxTable TablesawFxViewer = FxTable.build();
        TablesawFxViewer.setData(table);
        return TablesawFxViewer;
    }

    public void setData(Table table) {
        this.tableData = table;
        this.refreshTableView();
    }

    private void refreshTableView() {
        if (this.tableData == null) {
            return;
        }
        ObservableList data = FXCollections.observableArrayList();
        for (int i = 0; i < this.tableData.rowCount(); ++i) {
            data.add((Object)i);
        }
        ArrayList<TableColumn<Integer, String>> columnsList = new ArrayList<TableColumn<Integer, String>>();
        for (int iCol = 0; iCol < this.tableData.columnCount(); ++iCol) {
            TableColumn<Integer, String> newColumn = this.createColumn(this.tableData.column(iCol));
            columnsList.add(newColumn);
        }
        this.setItems(data);
        this.getColumns().setAll(columnsList);
    }

    private TableColumn<Integer, String> createColumn(final Column col) {
        TableColumn stringColumn = new TableColumn(col.name());
        stringColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Integer, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Integer, String> param) {
                int rowIndex = (Integer)param.getValue();
                String name = col.getString(rowIndex);
                return new SimpleStringProperty(name);
            }
        });
        return stringColumn;
    }
}

