/*
 * Decompiled with CFR 0.152.
 */
package tech.thdev.useful.encrypted.data.store.preferences.ksp.internal.generate;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSTypeParameter;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import tech.thdev.useful.encrypted.data.store.preferences.ksp.internal.DataStoreConst;
import tech.thdev.useful.encrypted.data.store.preferences.ksp.internal.StringUtilKt;
import tech.thdev.useful.encrypted.data.store.preferences.ksp.internal.UtilKt;
import tech.thdev.useful.encrypted.data.store.preferences.ksp.internal.model.ResearchModel;
import tech.thdev.useful.encrypted.data.store.preferences.ksp.internal.model.ValueModel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u0011\u001a\u00020\u0012*\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J0\u0010\u001d\u001a\u00020\u0010*\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J,\u0010 \u001a\u00020\u0018*\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltech/thdev/useful/encrypted/data/store/preferences/ksp/internal/generate/GeneratePreferences;", "", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lcom/google/devtools/ksp/processing/KSPLogger;)V", "generate", "", "researchModel", "Ltech/thdev/useful/encrypted/data/store/preferences/ksp/internal/model/ResearchModel;", "generatePreferenceImplClass", "className", "", "packageName", "keyClassName", "Lcom/squareup/kotlinpoet/ClassName;", "createProperty", "Lcom/squareup/kotlinpoet/PropertySpec$Builder;", "type", "typeBuilder", "fileSpec", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "generateGetFunction", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "Ltech/thdev/useful/encrypted/data/store/preferences/ksp/internal/model/ValueModel$Get;", "disableSecurity", "", "primaryContractValue", "generateKeysClass", "", "Lcom/google/devtools/ksp/symbol/KSName;", "generateSetFunction", "Ltech/thdev/useful/encrypted/data/store/preferences/ksp/internal/model/ValueModel$Set;", "useful-encrypted-data-store-preferences-ksp"})
public final class GeneratePreferences {
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final KSPLogger logger;

    public GeneratePreferences(@NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.codeGenerator = codeGenerator;
        this.logger = logger;
    }

    public final void generate(@NotNull ResearchModel researchModel) {
        Intrinsics.checkNotNullParameter((Object)researchModel, (String)"researchModel");
        String className = researchModel.getTargetClassDeclaration().getSimpleName().getShortName();
        String packageName = researchModel.getTargetClassDeclaration().getPackageName().asString();
        ClassName keyClassName = this.generateKeysClass(researchModel.getMergeKeyModel(), researchModel.getDisableSecurity(), className, packageName);
        this.generatePreferenceImplClass(className, packageName, keyClassName, researchModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ClassName generateKeysClass(Map<String, ? extends KSName> $this$generateKeysClass, boolean disableSecurity, String className, String packageName) {
        String newClassName = className + "Keys";
        String[] stringArray = new String[]{DataStoreConst.INSTANCE.getPREF_PREFERENCES().getSimpleName()};
        FileSpec.Builder builder = FileSpec.Companion.builder(packageName, newClassName).addImport(DataStoreConst.INSTANCE.getPREF_PREFERENCES().getPackageName(), stringArray);
        stringArray = new String[]{DataStoreConst.INSTANCE.getPREF_PREFERENCES_KEY().getSimpleName()};
        FileSpec.Builder fileSpec = builder.addImport(DataStoreConst.INSTANCE.getPREF_PREFERENCES_KEY().getPackageName(), stringArray);
        KModifier[] kModifierArray = new KModifier[]{KModifier.INTERNAL};
        TypeSpec.Builder classSpec = TypeSpec.Companion.objectBuilder(newClassName).addModifiers(kModifierArray);
        Map<String, ? extends KSName> map = $this$generateKeysClass;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends KSName>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            PropertySpec.Builder builder2;
            Map.Entry<String, ? extends KSName> element$iv;
            Map.Entry<String, ? extends KSName> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            KSName type = entry.getValue();
            if (disableSecurity) {
                String string = type.asString();
                if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE).getQualifiedName())) {
                    builder2 = this.createProperty(key, type.asString(), DataStoreConst.INSTANCE.getPREF_GENERATE_INT(), fileSpec);
                } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE).getQualifiedName())) {
                    builder2 = this.createProperty(key, type.asString(), DataStoreConst.INSTANCE.getPREF_GENERATE_DOUBLE(), fileSpec);
                } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(String.class).getQualifiedName())) {
                    builder2 = this.createProperty(key, type.asString(), DataStoreConst.INSTANCE.getPREF_GENERATE_STRING(), fileSpec);
                } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE).getQualifiedName())) {
                    builder2 = this.createProperty(key, type.asString(), DataStoreConst.INSTANCE.getPREF_GENERATE_BOOLEAN(), fileSpec);
                } else if (Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE).getQualifiedName())) {
                    builder2 = this.createProperty(key, type.asString(), DataStoreConst.INSTANCE.getPREF_GENERATE_FLOAT(), fileSpec);
                } else {
                    if (!Intrinsics.areEqual((Object)string, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE).getQualifiedName())) throw new Exception("Useful Preference generate is Not support type " + type.asString() + ", " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    builder2 = this.createProperty(key, type.asString(), DataStoreConst.INSTANCE.getPREF_GENERATE_LONG(), fileSpec);
                }
            } else {
                String string = Reflection.getOrCreateKotlinClass(String.class).getQualifiedName();
                if (string == null) {
                    string = "";
                }
                builder2 = this.createProperty(key, string, DataStoreConst.INSTANCE.getPREF_GENERATE_STRING(), fileSpec);
            }
            PropertySpec.Builder propertySpec = builder2;
            classSpec.addProperty(propertySpec.build());
        }
        fileSpec.addType(classSpec.build());
        UtilKt.writeTo(fileSpec.build(), this.codeGenerator, packageName, newClassName);
        String[] stringArray2 = new String[]{newClassName};
        return new ClassName(packageName, stringArray2);
    }

    private final PropertySpec.Builder createProperty(String $this$createProperty, String type, ClassName typeBuilder, FileSpec.Builder fileSpec) {
        String[] stringArray = new String[]{typeBuilder.getSimpleName()};
        fileSpec.addImport(typeBuilder.getPackageName(), stringArray);
        stringArray = new TypeName[]{(TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)type, null, (int)2, null)};
        return PropertySpec.Companion.builder(StringUtilKt.upperKey($this$createProperty), (TypeName)ParameterizedTypeName.Companion.get(DataStoreConst.INSTANCE.getPREF_PREFERENCES_KEY(), (TypeName[])stringArray), new KModifier[0]).initializer(typeBuilder.getSimpleName() + "(\"" + $this$createProperty + "\")", new Object[0]);
    }

    private final void generatePreferenceImplClass(String className, String packageName, ClassName keyClassName, ResearchModel researchModel) {
        FunSpec.Builder funSpec;
        TypeVariableName superClass = TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null);
        String newClassName = className + "Impl";
        FileSpec.Builder fileSpec = FileSpec.Companion.builder(packageName, newClassName);
        KModifier[] kModifierArray = new KModifier[]{KModifier.INTERNAL};
        TypeSpec.Builder classSpec = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.classBuilder(newClassName).addModifiers(kModifierArray), (TypeName)((TypeName)superClass), null, (int)2, null);
        String primaryPreferencesStore = "preferencesStore";
        TypeName[] typeNameArray = new TypeName[]{(TypeName)DataStoreConst.INSTANCE.getPREF_PREFERENCES()};
        ParameterizedTypeName primaryPreferencesStoreType = ParameterizedTypeName.Companion.get(DataStoreConst.INSTANCE.getPREF_DATA_STORE(), typeNameArray);
        if (researchModel.getDisableSecurity()) {
            typeNameArray = new KModifier[]{KModifier.PRIVATE};
            classSpec.primaryConstructor(FunSpec.Companion.constructorBuilder().addParameter(primaryPreferencesStore, (TypeName)primaryPreferencesStoreType, new KModifier[0]).build()).addProperty(PropertySpec.Companion.builder(primaryPreferencesStore, (TypeName)primaryPreferencesStoreType, new KModifier[0]).initializer(primaryPreferencesStore, new Object[0]).addModifiers((KModifier[])typeNameArray).build());
        } else {
            String primarySecurity = "usefulSecurity";
            ClassName primarySecurityType = DataStoreConst.INSTANCE.getUSEFUL_SECURITY();
            Object object = new KModifier[]{KModifier.PRIVATE};
            TypeSpec.Builder builder = classSpec.primaryConstructor(FunSpec.Companion.constructorBuilder().addParameter(primarySecurity, (TypeName)primarySecurityType, new KModifier[0]).addParameter(primaryPreferencesStore, (TypeName)primaryPreferencesStoreType, new KModifier[0]).build()).addProperty(PropertySpec.Companion.builder(primarySecurity, (TypeName)primarySecurityType, new KModifier[0]).initializer(primarySecurity, new Object[0]).addModifiers((KModifier[])object).build());
            object = new KModifier[]{KModifier.PRIVATE};
            builder.addProperty(PropertySpec.Companion.builder(primaryPreferencesStore, (TypeName)primaryPreferencesStoreType, new KModifier[0]).initializer(primaryPreferencesStore, new Object[0]).addModifiers((KModifier[])object).build());
        }
        Iterable $this$forEach$iv = researchModel.getValueModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FunSpec.Builder funSpec2;
            ValueModel item = (ValueModel)element$iv;
            boolean bl = false;
            ValueModel valueModel = item;
            if (valueModel instanceof ValueModel.Get) {
                funSpec2 = this.generateGetFunction((ValueModel.Get)item, researchModel.getDisableSecurity(), fileSpec, primaryPreferencesStore, keyClassName.getSimpleName());
                classSpec.addFunction(funSpec2.build());
                continue;
            }
            if (!(valueModel instanceof ValueModel.Set)) continue;
            funSpec2 = this.generateSetFunction((ValueModel.Set)item, researchModel.getDisableSecurity(), fileSpec, primaryPreferencesStore, keyClassName.getSimpleName());
            classSpec.addFunction(funSpec2.build());
        }
        fileSpec.addType(classSpec.build());
        if (researchModel.getDisableSecurity()) {
            Object[] objectArray = new Object[]{newClassName, "preferencesStore"};
            funSpec = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(StringUtilKt.mergePrefixGenerate(className)), (TypeName)((TypeName)superClass), null, (int)2, null), (TypeName)((TypeName)primaryPreferencesStoreType), null, (int)2, null).addStatement("return %N(%N = this)", objectArray);
            fileSpec.addFunction(funSpec.build());
        } else {
            Object[] objectArray = new Object[]{newClassName, "preferencesStore", "usefulSecurity", "usefulSecurity"};
            funSpec = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(StringUtilKt.mergePrefixGenerate(className)), (TypeName)((TypeName)superClass), null, (int)2, null), (TypeName)((TypeName)primaryPreferencesStoreType), null, (int)2, null).addParameter(ParameterSpec.Companion.builder("usefulSecurity", (TypeName)DataStoreConst.INSTANCE.getUSEFUL_SECURITY(), new KModifier[0]).build()).addStatement("return %N(%N = this, %N = %N)", objectArray);
            fileSpec.addFunction(funSpec.build());
        }
        UtilKt.writeTo(fileSpec.build(), this.codeGenerator, packageName, newClassName);
    }

    private final FunSpec.Builder generateSetFunction(ValueModel.Set $this$generateSetFunction, boolean disableSecurity, FileSpec.Builder fileSpec, String primaryContractValue, String keyClassName) {
        KSValueParameter parameter;
        KModifier[] kModifierArray = new KModifier[]{KModifier.OVERRIDE, KModifier.PUBLIC};
        FunSpec.Builder funSpec = FunSpec.Companion.builder($this$generateSetFunction.getFunctionInfo().getSimpleName().asString()).addModifiers(kModifierArray);
        if ($this$generateSetFunction.isSuspend()) {
            kModifierArray = new KModifier[]{KModifier.SUSPEND};
            funSpec.addModifiers(kModifierArray);
        }
        if ((parameter = (KSValueParameter)CollectionsKt.firstOrNull((List)$this$generateSetFunction.getFunctionInfo().getParameters())) != null) {
            KSName kSName = parameter.getName();
            if ((kSName != null ? kSName.asString() : null) != null) {
                KSName kSName2 = parameter.getName();
                Intrinsics.checkNotNull((Object)kSName2);
                String parameterName = kSName2.asString();
                funSpec.addParameter(parameterName, (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)parameter.getType().resolve().getDeclaration().getSimpleName().asString(), null, (int)2, null), new KModifier[0]);
                if (disableSecurity) {
                    String[] stringArray = new String[]{DataStoreConst.INSTANCE.getPREF_DATA_STORE_EDIT().getSimpleName()};
                    fileSpec.addImport(DataStoreConst.INSTANCE.getPREF_DATA_STORE_EDIT().getPackageName(), stringArray);
                    funSpec.addStatement(primaryContractValue + '.' + DataStoreConst.INSTANCE.getPREF_DATA_STORE_EDIT().getSimpleName() + " {\nit[" + keyClassName + '.' + StringUtilKt.upperKey($this$generateSetFunction.getKey()) + "] = " + parameterName + "\n}", new Object[0]);
                } else {
                    String[] stringArray = new String[]{DataStoreConst.INSTANCE.getUSEFUL_EDIT_ENCRYPT().getSimpleName()};
                    fileSpec.addImport(DataStoreConst.INSTANCE.getUSEFUL_EDIT_ENCRYPT().getPackageName(), stringArray);
                    funSpec.addStatement(primaryContractValue + '.' + DataStoreConst.INSTANCE.getUSEFUL_EDIT_ENCRYPT().getSimpleName() + "(usefulSecurity, " + parameterName + ") { preferences, encrypted -> \npreferences[" + keyClassName + '.' + StringUtilKt.upperKey($this$generateSetFunction.getKey()) + "] = encrypted\n}", new Object[0]);
                }
            }
        }
        return funSpec;
    }

    private final FunSpec.Builder generateGetFunction(ValueModel.Get $this$generateGetFunction, boolean disableSecurity, FileSpec.Builder fileSpec, String primaryContractValue, String keyClassName) {
        Object[] objectArray = new KModifier[]{KModifier.OVERRIDE, KModifier.PUBLIC};
        FunSpec.Builder funSpec = FunSpec.Companion.builder($this$generateGetFunction.getFunctionInfo().getSimpleName().asString()).addModifiers(objectArray);
        if ($this$generateGetFunction.isSuspend()) {
            objectArray = new String[]{DataStoreConst.INSTANCE.getFLOW_FIRST().getSimpleName()};
            fileSpec.addImport(DataStoreConst.INSTANCE.getFLOW_FIRST().getPackageName(), (String[])objectArray);
            objectArray = new KModifier[]{KModifier.SUSPEND};
            FunSpec.Builder.returns$default((FunSpec.Builder)funSpec.addModifiers(objectArray), (TypeName)((TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)$this$generateGetFunction.getValueType().getShortName(), null, (int)2, null)), null, (int)2, null);
            if (disableSecurity) {
                objectArray = new String[]{DataStoreConst.INSTANCE.getFLOW_MAP().getSimpleName()};
                fileSpec.addImport(DataStoreConst.INSTANCE.getFLOW_MAP().getPackageName(), (String[])objectArray);
                funSpec.addCode(GeneratePreferences.generateGetFunction$getMap($this$generateGetFunction.getValueType().getShortName(), primaryContractValue, keyClassName, $this$generateGetFunction) + "\n.first()", new Object[0]);
            } else {
                objectArray = new String[]{DataStoreConst.INSTANCE.getFLOW_MAP_DECRYPT().getSimpleName()};
                fileSpec.addImport(DataStoreConst.INSTANCE.getFLOW_MAP_DECRYPT().getPackageName(), (String[])objectArray);
                objectArray = new String[]{DataStoreConst.INSTANCE.getUSEFUL_TYPE().getSimpleName()};
                fileSpec.addImport(DataStoreConst.INSTANCE.getUSEFUL_TYPE().getPackageName(), (String[])objectArray);
                funSpec.addCode(GeneratePreferences.generateGetFunction$getMapDecrypt($this$generateGetFunction.getValueType().getShortName(), primaryContractValue, keyClassName, $this$generateGetFunction) + "\n.first()", new Object[0]);
            }
        } else if (UtilKt.hasFlow($this$generateGetFunction.getFunctionInfo())) {
            Object object = UtilKt.getReturnResolve($this$generateGetFunction.getFunctionInfo());
            if (object != null && (object = object.getTypeParameters()) != null && (object = (KSTypeParameter)CollectionsKt.firstOrNull((List)object)) != null) {
                boolean bl = false;
                KSDeclaration kSDeclaration = UtilKt.getReturnResolve($this$generateGetFunction.getFunctionInfo());
                if ((kSDeclaration != null ? kSDeclaration.getQualifiedName() : null) != null) {
                    KSDeclaration kSDeclaration2 = UtilKt.getReturnElement($this$generateGetFunction.getFunctionInfo());
                    if ((kSDeclaration2 != null ? kSDeclaration2.getSimpleName() : null) != null) {
                        KSDeclaration kSDeclaration3 = UtilKt.getReturnResolve($this$generateGetFunction.getFunctionInfo());
                        Intrinsics.checkNotNull((Object)kSDeclaration3);
                        KSName kSName = kSDeclaration3.getQualifiedName();
                        Intrinsics.checkNotNull((Object)kSName);
                        KSName genericName = kSName;
                        KSDeclaration kSDeclaration4 = UtilKt.getReturnElement($this$generateGetFunction.getFunctionInfo());
                        Intrinsics.checkNotNull((Object)kSDeclaration4);
                        String typeName = kSDeclaration4.getSimpleName().getShortName();
                        String[] stringArray = new String[]{genericName.getShortName()};
                        ClassName genericClassName = new ClassName(genericName.getQualifier(), stringArray);
                        stringArray = new TypeName[]{(TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)typeName, null, (int)2, null)};
                        FunSpec.Builder.returns$default((FunSpec.Builder)funSpec, (TypeName)((TypeName)ParameterizedTypeName.Companion.get(genericClassName, (TypeName[])stringArray)), null, (int)2, null);
                        if (disableSecurity) {
                            stringArray = new String[]{DataStoreConst.INSTANCE.getFLOW_MAP().getSimpleName()};
                            fileSpec.addImport(DataStoreConst.INSTANCE.getFLOW_MAP().getPackageName(), stringArray);
                            funSpec.addCode(GeneratePreferences.generateGetFunction$getMap(typeName, primaryContractValue, keyClassName, $this$generateGetFunction), new Object[0]);
                        } else {
                            stringArray = new String[]{DataStoreConst.INSTANCE.getFLOW_MAP_DECRYPT().getSimpleName()};
                            fileSpec.addImport(DataStoreConst.INSTANCE.getFLOW_MAP_DECRYPT().getPackageName(), stringArray);
                            stringArray = new String[]{DataStoreConst.INSTANCE.getUSEFUL_TYPE().getSimpleName()};
                            fileSpec.addImport(DataStoreConst.INSTANCE.getUSEFUL_TYPE().getPackageName(), stringArray);
                            funSpec.addCode(GeneratePreferences.generateGetFunction$getMapDecrypt(typeName, primaryContractValue, keyClassName, $this$generateGetFunction), new Object[0]);
                        }
                    }
                }
            }
        } else {
            throw new Exception("Not support type");
        }
        return funSpec;
    }

    private static final String generateGetFunction$getMap(String $this$generateGetFunction_u24getMap, String $primaryContractValue, String $keyClassName, ValueModel.Get $this_generateGetFunction) {
        return "return " + $primaryContractValue + ".data\n.map {\nit[" + $keyClassName + '.' + StringUtilKt.upperKey($this_generateGetFunction.getKey()) + "] ?: " + UtilKt.generateDefaultValue($this$generateGetFunction_u24getMap) + "\n}";
    }

    private static final String generateGetFunction$getMapDecrypt(String $this$generateGetFunction_u24getMapDecrypt, String $primaryContractValue, String $keyClassName, ValueModel.Get $this_generateGetFunction) {
        return "return " + $primaryContractValue + ".data\n.mapDecrypt<" + $this$generateGetFunction_u24getMapDecrypt + ">(usefulSecurity, " + UtilKt.convertEncryptType($this$generateGetFunction_u24getMapDecrypt) + ") {\nit[" + $keyClassName + '.' + StringUtilKt.upperKey($this_generateGetFunction.getKey()) + "]\n}";
    }
}

