/*
 * Decompiled with CFR 0.152.
 */
package com.touchbiz.mq.starter;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.touchbiz.mq.starter.configuration.RocketMqConfig;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RocketConsumer {
    private static final Logger log = LoggerFactory.getLogger(RocketConsumer.class);
    private RocketMqConfig config;
    private MessageListener messageListener;
    private Consumer consumer;
    private String topic;
    private String tag;
    private String groupId;
    private Integer consumeThreadNums;
    private String topicType;

    private void init() {
        Properties properties = new Properties();
        if (!StringUtils.isEmpty((Object)this.groupId)) {
            properties.put("GROUP_ID", this.groupId);
        }
        if (this.consumeThreadNums != null) {
            properties.put("ConsumeThreadNums", this.consumeThreadNums);
        }
        properties.put("AccessKey", this.config.getAccessKey());
        properties.put("SecretKey", this.config.getSecretKey());
        properties.put("SendMsgTimeoutMillis", "3000");
        properties.put("NAMESRV_ADDR", this.config.getNamedAddress());
        this.consumer = ONSFactory.createConsumer((Properties)properties);
        this.consumer.subscribe(this.topic, this.tag, this.messageListener);
        this.consumer.start();
        log.info("RocketConsumer init success,topic name:{},listener:{}", (Object)this.topic, (Object)this.messageListener.getClass().getName());
    }

    private synchronized void close() {
        if (this.consumer != null) {
            try {
                this.consumer.shutdown();
            }
            catch (Exception e) {
                log.error("rocket consumer close exception", (Throwable)e);
            }
        }
    }

    public RocketMqConfig getConfig() {
        return this.config;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTag() {
        return this.tag;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Integer getConsumeThreadNums() {
        return this.consumeThreadNums;
    }

    public String getTopicType() {
        return this.topicType;
    }

    public void setConfig(RocketMqConfig config) {
        this.config = config;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setConsumeThreadNums(Integer consumeThreadNums) {
        this.consumeThreadNums = consumeThreadNums;
    }

    public void setTopicType(String topicType) {
        this.topicType = topicType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocketConsumer)) {
            return false;
        }
        RocketConsumer other = (RocketConsumer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$consumeThreadNums = this.getConsumeThreadNums();
        Integer other$consumeThreadNums = other.getConsumeThreadNums();
        if (this$consumeThreadNums == null ? other$consumeThreadNums != null : !((Object)this$consumeThreadNums).equals(other$consumeThreadNums)) {
            return false;
        }
        RocketMqConfig this$config = this.getConfig();
        RocketMqConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        MessageListener this$messageListener = this.getMessageListener();
        MessageListener other$messageListener = other.getMessageListener();
        if (this$messageListener == null ? other$messageListener != null : !this$messageListener.equals(other$messageListener)) {
            return false;
        }
        Consumer this$consumer = this.getConsumer();
        Consumer other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$topicType = this.getTopicType();
        String other$topicType = other.getTopicType();
        return !(this$topicType == null ? other$topicType != null : !this$topicType.equals(other$topicType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RocketConsumer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $consumeThreadNums = this.getConsumeThreadNums();
        result = result * 59 + ($consumeThreadNums == null ? 43 : ((Object)$consumeThreadNums).hashCode());
        RocketMqConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        MessageListener $messageListener = this.getMessageListener();
        result = result * 59 + ($messageListener == null ? 43 : $messageListener.hashCode());
        Consumer $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $topicType = this.getTopicType();
        result = result * 59 + ($topicType == null ? 43 : $topicType.hashCode());
        return result;
    }

    public String toString() {
        return "RocketConsumer(config=" + this.getConfig() + ", messageListener=" + this.getMessageListener() + ", consumer=" + this.getConsumer() + ", topic=" + this.getTopic() + ", tag=" + this.getTag() + ", groupId=" + this.getGroupId() + ", consumeThreadNums=" + this.getConsumeThreadNums() + ", topicType=" + this.getTopicType() + ")";
    }
}

