/*
 * Decompiled with CFR 0.152.
 */
package com.touchbiz.mq.starter;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.touchbiz.common.utils.text.StringSpliceUtils;
import com.touchbiz.common.utils.tools.JsonUtils;
import com.touchbiz.mq.starter.configuration.MqConfigProperties;
import com.touchbiz.mq.starter.configuration.RocketMqConfig;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RocketProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketProducer.class);
    private static ConcurrentHashMap<String, Pair<MqConfigProperties, Producer>> producerMap;
    private final RocketMqConfig config;

    public RocketProducer(RocketMqConfig config) {
        this.config = config;
    }

    public static SendResult sendMessage(String topicType, Object data) throws Exception {
        return RocketProducer.internalSendMessage(topicType, data, null, pair -> ((Producer)pair.getKey()).send((Message)pair.getValue()));
    }

    public static SendResult sendMessage(String topicType, Object data, Date deliverTime) throws Exception {
        return RocketProducer.internalSendMessage(topicType, data, deliverTime, pair -> ((Producer)pair.getKey()).send((Message)pair.getValue()));
    }

    public static void sendOnewayMessage(String topicType, Object data) throws Exception {
        RocketProducer.internalSendMessage(topicType, data, null, pair -> {
            ((Producer)pair.getKey()).sendOneway((Message)pair.getValue());
            return null;
        });
    }

    public static void sendOnewayMessage(String topicType, Object data, Date deliverTime) throws Exception {
        RocketProducer.internalSendMessage(topicType, data, deliverTime, pair -> {
            ((Producer)pair.getKey()).sendOneway((Message)pair.getValue());
            return null;
        });
    }

    public static void sendAsyncMessage(String topicType, Object data, SendCallback callback) throws Exception {
        RocketProducer.check(topicType);
        Pair<MqConfigProperties, Producer> pair = producerMap.get(topicType);
        try {
            ((Producer)pair.getValue()).sendAsync(RocketProducer.generateMessage(topicType, data, null), callback);
        }
        catch (Exception e) {
            log.info("sendAsyncMessage rocket producer[" + topicType + "]  msg[" + data + "] exception,e=", (Throwable)e);
        }
    }

    public static void sendAsyncMessage(String topicType, Object data, Date deliverTime, SendCallback callback) throws Exception {
        RocketProducer.check(topicType);
        Pair<MqConfigProperties, Producer> pair = producerMap.get(topicType);
        try {
            ((Producer)pair.getValue()).sendAsync(RocketProducer.generateMessage(topicType, data, deliverTime), callback);
        }
        catch (Exception e) {
            log.info("sendAsyncMessage rocket producer[" + topicType + "]  msg[" + data + "] exception,e=", (Throwable)e);
        }
    }

    private static SendResult internalSendMessage(String topicType, Object data, Date deliverTime, Function<Pair<Producer, Message>, SendResult> function) throws Exception {
        SendResult result;
        RocketProducer.check(topicType);
        Pair<MqConfigProperties, Producer> pair = producerMap.get(topicType);
        try {
            result = function.apply((Pair<Producer, Message>)new MutablePair((Object)((Producer)pair.getValue()), (Object)RocketProducer.generateMessage(topicType, data, deliverTime)));
            if (result.getMessageId() != null) {
                log.info("sendMessage rocket success. producer={}, msg={},messageId={}", new Object[]{topicType, data, result.getMessageId()});
            } else {
                log.info("sendMessage rocket fail. producer={}, msg={}", (Object)topicType, data);
            }
        }
        catch (Exception e) {
            log.info("sendMessage rocket producer[" + topicType + "]  msg[" + data + "] exception,e=", (Throwable)e);
            result = null;
        }
        return result;
    }

    private static void check(String topicType) throws Exception {
        if (CollectionUtils.isEmpty(producerMap)) {
            log.error("sendMessage mafka producerMap has not init");
            throw new Exception("\u6ca1\u6709\u4efb\u4f55\u961f\u5217\u65e0\u6cd5\u53d1\u9001");
        }
        if (!producerMap.containsKey(topicType) || producerMap.get(topicType) == null) {
            log.error("sendMessage rocket producer={} has not init", (Object)topicType);
            throw new Exception(StringSpliceUtils.splice((String)"\u4e0d\u5b58\u5728{}\u8be5\u961f\u5217,\u65e0\u6cd5\u8fdb\u884c\u53d1\u9001\u64cd\u4f5c", (Object[])new Object[]{topicType}));
        }
    }

    private static Message generateMessage(String topicType, Object data, Date deliverTime) {
        if (data == null) {
            log.error("sendMessage  rocket producer={}, param o is null", (Object)topicType);
            return null;
        }
        String msg = data instanceof String ? (String)data : (data instanceof JSONObject ? ((JSONObject)data).toJSONString() : JsonUtils.toJson((Object)data));
        if (msg == null) {
            log.error("sendMessage rocket producer={}. msg is null", (Object)topicType);
            return null;
        }
        Pair<MqConfigProperties, Producer> pair = producerMap.get(topicType);
        Message message = new Message(((MqConfigProperties)pair.getKey()).getTopic(), ((MqConfigProperties)pair.getKey()).getTag(), msg.getBytes());
        if (deliverTime != null) {
            message.setStartDeliverTime(deliverTime.getTime());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (producerMap != null) {
            return;
        }
        Class<RocketProducer> clazz = RocketProducer.class;
        synchronized (RocketProducer.class) {
            log.info("init rocket producerMap,configuration:{}", (Object)this.config);
            producerMap = new ConcurrentHashMap(16);
            List<MqConfigProperties> topic = this.config.getTopic();
            if (topic == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (MqConfigProperties mqConfigProperties : topic) {
                Properties properties = new Properties();
                if (!StringUtils.isEmpty((CharSequence)this.config.getGroupId())) {
                    properties.put("GROUP_ID", this.config.getGroupId());
                }
                properties.put("AccessKey", this.config.getAccessKey());
                properties.put("SecretKey", this.config.getSecretKey());
                properties.setProperty("SendMsgTimeoutMillis", "3000");
                properties.put("NAMESRV_ADDR", this.config.getNamedAddress());
                Producer producer = ONSFactory.createProducer((Properties)properties);
                producer.start();
                log.info("rocket producer[" + mqConfigProperties.getTopic() + "] init success");
                ImmutablePair pair = new ImmutablePair((Object)mqConfigProperties, (Object)producer);
                producerMap.put(mqConfigProperties.getType(), (Pair<MqConfigProperties, Producer>)pair);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private synchronized void close() {
        if (producerMap == null) {
            return;
        }
        if (producerMap.size() == 0) {
            producerMap = null;
            return;
        }
        for (Pair<MqConfigProperties, Producer> pair : producerMap.values()) {
            Producer processor = (Producer)pair.getValue();
            if (processor == null) continue;
            try {
                processor.shutdown();
            }
            catch (Exception e) {
                log.error("rocket producer close exception", (Throwable)e);
            }
        }
        producerMap.clear();
        producerMap = null;
    }
}

