/*
 * Decompiled with CFR 0.152.
 */
package com.touchbiz.mq.starter.configuration;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.touchbiz.mq.starter.RocketProducer;
import com.touchbiz.mq.starter.configuration.RocketMqConfig;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class MqConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MqConfiguration.class);
    @Value(value="${spring.application.name}")
    private String groupId;
    @Value(value="${cryptoConfig:true}")
    private Boolean cryptoConfig;

    @Bean(initMethod="init", destroyMethod="close")
    public RocketProducer producerFactory(RocketMqConfig config) {
        return new RocketProducer(config);
    }

    @Bean
    @ConfigurationProperties(prefix="mq")
    public RocketMqConfig rocketMqConfig(NacosConfigProperties nacosConfigProperties) throws NacosException {
        RocketMqConfig config = new RocketMqConfig();
        String configInfo = nacosConfigProperties.configServiceInstance().getConfig("MQ_CONFIG", this.groupId, 3000L);
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(configInfo));
            config.setAccessKey(properties.getProperty("accessKey"));
            config.setSecretKey(properties.getProperty("secretKey"));
            config.setGroupId(properties.getProperty("groupId"));
            config.setNamedAddress(properties.getProperty("namedAddress"));
        }
        catch (IOException e) {
            log.error("rocketMqConfig->error->", (Throwable)e);
        }
        return config;
    }
}

