/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis;

import java.sql.SQLException;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.transaction.Transaction;
import tech.wetech.mybatis.EntityMapperRegistry;
import tech.wetech.mybatis.PagingExecutor;
import tech.wetech.mybatis.dialect.Dialect;
import tech.wetech.mybatis.dialect.DialectClient;
import tech.wetech.mybatis.dialect.DialectType;
import tech.wetech.mybatis.mapper.Mapper;

public class ExtConfiguration
extends Configuration {
    protected final EntityMapperRegistry entityMapperRegistry = new EntityMapperRegistry(this);
    protected Dialect dialect = null;

    public ExtConfiguration() {
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Class<? extends Dialect> dialect) {
        try {
            this.dialect = dialect.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ExceptionFactory.wrapException((String)"Cannot set dialect.", (Exception)e);
        }
    }

    public ExtConfiguration(Environment environment) {
        this();
        this.environment = environment;
    }

    public <T> void addMapper(Class<T> type) {
        this.entityMapperRegistry.addMapper(type);
    }

    public void addMappers(String packageName, Class<?> superType) {
        this.entityMapperRegistry.addMappers(packageName, superType);
    }

    public void addMappers(String packageName) {
        this.entityMapperRegistry.addMappers(packageName);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return this.entityMapperRegistry.getMapper(type, sqlSession);
    }

    public boolean hasMapper(Class<?> type) {
        return type == Mapper.class || this.entityMapperRegistry.hasMapper(type);
    }

    public Executor newExecutor(Transaction transaction, ExecutorType executorType) {
        Executor executor = super.newExecutor(transaction, executorType);
        Dialect dialect = this.dialect != null ? this.dialect : this.getAutoDialect(transaction);
        return dialect == null ? executor : new PagingExecutor(executor, dialect);
    }

    public Dialect getAutoDialect(Transaction transaction) {
        try {
            String url = transaction.getConnection().getMetaData().getURL();
            for (DialectType dialectType : DialectType.values()) {
                if (url.toUpperCase().indexOf(String.format(":%s:", new Object[]{dialectType})) == -1) continue;
                return DialectClient.getDialect(dialectType);
            }
        }
        catch (SQLException e) {
            ExceptionFactory.wrapException((String)"Cannot get auto dialect.", (Exception)e);
        }
        return null;
    }
}

