/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import tech.wetech.mybatis.ParametersFinder;
import tech.wetech.mybatis.ThreadContext;
import tech.wetech.mybatis.dialect.Dialect;
import tech.wetech.mybatis.domain.Page;

public class PagingExecutor
implements Executor {
    private final Executor delegate;
    private final Dialect dialect;

    public int getTotalCount(MappedStatement ms, Object parameterObject, BoundSql boundSql, Dialect dialect) throws SQLException {
        Log statementLog = ms.getStatementLog();
        String countSql = dialect.getCountString(boundSql.getSql());
        if (statementLog.isDebugEnabled()) {
            statementLog.debug("==>   CountSQL: " + countSql);
        }
        Connection connection = this.getTransaction().getConnection();
        PreparedStatement countStmt = connection.prepareStatement(countSql);
        DefaultParameterHandler handler = new DefaultParameterHandler(ms, parameterObject, boundSql);
        handler.setParameters(countStmt);
        ResultSet rs = countStmt.executeQuery();
        int count = 0;
        if (rs.next()) {
            count = rs.getInt(1);
        }
        if (statementLog.isDebugEnabled()) {
            statementLog.debug("==> TotalCount: " + count);
        }
        return count;
    }

    public PagingExecutor(Executor delegate, Dialect dialect) {
        this.delegate = delegate;
        this.dialect = dialect;
    }

    public int update(MappedStatement ms, Object parameter) throws SQLException {
        return this.delegate.update(ms, parameter);
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    private Page getPage(Object parameter) {
        Page page = ParametersFinder.getInstance().findParameter(parameter, Page.class);
        if (page == null && ThreadContext.getPage() != null) {
            try {
                page = ThreadContext.getPage();
            }
            finally {
                ThreadContext.removeAll();
            }
        }
        return page;
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, CacheKey cacheKey, BoundSql boundSql) throws SQLException {
        Page page = this.getPage(parameter);
        if (page != null) {
            int totalCount = 0;
            if (page.isCountable()) {
                try {
                    totalCount = this.getTotalCount(ms, parameter, boundSql, this.dialect);
                }
                catch (SQLException e) {
                    ExceptionFactory.wrapException((String)"Total count error: ", (Exception)e);
                }
                if (totalCount == 0) {
                    return page;
                }
                page.setTotal(totalCount);
            }
            if (page.getPageSize() < 1) {
                return page;
            }
            String sql = boundSql.getSql();
            String limitSql = this.dialect.getLimitString(sql, page.getOffset(), page.getPageSize());
            BoundSql newBoundSql = this.copyFromBoundSql(ms, boundSql, limitSql);
            List list = this.delegate.query(ms, parameter, rowBounds, resultHandler, cacheKey, newBoundSql);
            page.addAll(list);
            return page;
        }
        return this.delegate.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        BoundSql boundSql = ms.getBoundSql(parameter);
        CacheKey cacheKey = this.delegate.createCacheKey(ms, parameter, rowBounds, boundSql);
        return this.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public <E> Cursor<E> queryCursor(MappedStatement ms, Object parameter, RowBounds rowBounds) throws SQLException {
        return this.delegate.queryCursor(ms, parameter, rowBounds);
    }

    public List<BatchResult> flushStatements() throws SQLException {
        return this.delegate.flushStatements();
    }

    public void commit(boolean required) throws SQLException {
        this.delegate.commit(required);
    }

    public void rollback(boolean required) throws SQLException {
        this.delegate.rollback(required);
    }

    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        return this.delegate.createCacheKey(ms, parameterObject, rowBounds, boundSql);
    }

    public boolean isCached(MappedStatement ms, CacheKey key) {
        return this.delegate.isCached(ms, key);
    }

    public void clearLocalCache() {
        this.delegate.clearLocalCache();
    }

    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key, Class<?> targetType) {
        this.delegate.deferLoad(ms, resultObject, property, key, targetType);
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public void close(boolean forceRollback) {
        this.delegate.close(forceRollback);
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setExecutorWrapper(Executor executor) {
        this.delegate.setExecutorWrapper(executor);
    }
}

