/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class ParametersFinder {
    private static ParametersFinder parametersFinder = null;

    public static ParametersFinder getInstance() {
        if (parametersFinder != null) {
            return parametersFinder;
        }
        return new ParametersFinder();
    }

    public <T> T findParameter(Object parameterObject, Class<T> clazz) {
        return this.findParameterFromObject(parameterObject, clazz);
    }

    public <T> T findParameterFromObject(Object parameterObject, Class<T> clazz) {
        if (parameterObject == null) {
            return null;
        }
        Class<?> pClass = parameterObject.getClass();
        if (clazz == pClass || clazz.isAssignableFrom(pClass)) {
            return (T)parameterObject;
        }
        if (parameterObject instanceof Map) {
            return this.findParameterFromMap((Map)parameterObject, clazz);
        }
        if (parameterObject instanceof Collection) {
            return this.findParameterFromCollection((Collection)parameterObject, clazz);
        }
        if (pClass.isArray()) {
            return this.findParameterFromArray(parameterObject, clazz);
        }
        return null;
    }

    public <T> T findParameterFromMap(Map map, Class<T> clazz) {
        for (Object value : map.values()) {
            T parameterFromObject = this.findParameterFromObject(value, clazz);
            if (parameterFromObject == null) continue;
            return parameterFromObject;
        }
        return null;
    }

    public <T> T findParameterFromCollection(Collection collection, Class<T> clazz) {
        for (Object value : collection) {
            T parameterFromObject = this.findParameterFromObject(value, clazz);
            if (parameterFromObject == null) continue;
            return parameterFromObject;
        }
        return null;
    }

    private <T> T findParameterFromArray(Object array, Class<T> clazz) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            T parameterFromObject = this.findParameterFromObject(Array.get(array, i), clazz);
            if (parameterFromObject == null) continue;
            return parameterFromObject;
        }
        return null;
    }
}

