/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.SqlCommandType;
import tech.wetech.mybatis.ExtConfiguration;
import tech.wetech.mybatis.annotation.DeleteEntityProvider;
import tech.wetech.mybatis.annotation.EntityProviderSqlCommandType;
import tech.wetech.mybatis.annotation.InsertEntityProvider;
import tech.wetech.mybatis.annotation.SelectEntityProvider;
import tech.wetech.mybatis.annotation.UpdateEntityProvider;
import tech.wetech.mybatis.builder.EntityMapping;

public class EntityMapperAnnotationResolver {
    private final Method method;
    private final ExtConfiguration configuration;
    private final EntityMapping entityMapping;
    private boolean isEntityMethodProvider;
    private SqlCommandType sqlCommandType;
    private String script;
    private final Log log = LogFactory.getLog(EntityMapperAnnotationResolver.class);
    private static final Set<Class<? extends Annotation>> SQL_ENTITY_PROVIDER_ANNOTATION_TYPES = new HashSet<Class<? extends Annotation>>();
    private final Map<Class, Object> injectArgsMap = new HashMap<Class, Object>();

    public EntityMapperAnnotationResolver(Method method, ExtConfiguration configuration, EntityMapping entityMapping) {
        this.method = method;
        this.configuration = configuration;
        this.entityMapping = entityMapping;
        this.injectArgsMap.put(((Object)((Object)configuration)).getClass(), (Object)configuration);
        this.injectArgsMap.put(entityMapping.getClass(), entityMapping);
        Class<? extends Annotation> sqlEntityProviderAnnotationType = this.getSqlEntityProviderAnnotationType(method);
        if (sqlEntityProviderAnnotationType != null) {
            Annotation annotation = method.getAnnotation(sqlEntityProviderAnnotationType);
            try {
                Class providerMethodClass = (Class)sqlEntityProviderAnnotationType.getMethod("type", new Class[0]).invoke((Object)annotation, new Object[0]);
                String providerMethodName = (String)sqlEntityProviderAnnotationType.getMethod("method", new Class[0]).invoke((Object)annotation, new Object[0]);
                this.sqlCommandType = sqlEntityProviderAnnotationType.getAnnotation(EntityProviderSqlCommandType.class).value();
                this.isEntityMethodProvider = true;
                List providerMethods = Stream.of(providerMethodClass.getMethods()).filter(m -> providerMethodName.equals(m.getName())).collect(Collectors.toList());
                if (providerMethods.size() == 0) {
                    String msg = String.format("Not found method %s in class %s", providerMethodName, providerMethodClass);
                    this.log.error(msg);
                    throw new BuilderException(msg);
                }
                if (providerMethods.size() > 1) {
                    String msg = String.format("Found multi method %s in class %s", providerMethodName, providerMethodClass);
                    this.log.error(msg);
                    throw new BuilderException(msg);
                }
                Method providerMethod = (Method)providerMethods.get(0);
                Parameter[] parameters = providerMethod.getParameters();
                Object[] args = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    args[i] = this.injectArgsMap.get(parameters[i].getType());
                }
                this.script = providerMethod.invoke(providerMethodClass.newInstance(), args).toString();
                this.isEntityMethodProvider = true;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new BuilderException((Throwable)e);
            }
        } else {
            this.isEntityMethodProvider = false;
        }
    }

    public boolean isEntityMethodProvider() {
        return this.isEntityMethodProvider;
    }

    public SqlCommandType getSqlCommandType() {
        return this.sqlCommandType;
    }

    public String getScript() {
        return this.script;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExtConfiguration getConfiguration() {
        return this.configuration;
    }

    public EntityMapping getEntityMapping() {
        return this.entityMapping;
    }

    private Class<? extends Annotation> chooseAnnotationType(Method method, Set<Class<? extends Annotation>> types) {
        for (Class<? extends Annotation> type : types) {
            Annotation annotation = method.getAnnotation(type);
            if (annotation == null) continue;
            return type;
        }
        return null;
    }

    private Class<? extends Annotation> getSqlEntityProviderAnnotationType(Method method) {
        return this.chooseAnnotationType(method, SQL_ENTITY_PROVIDER_ANNOTATION_TYPES);
    }

    static {
        SQL_ENTITY_PROVIDER_ANNOTATION_TYPES.add(SelectEntityProvider.class);
        SQL_ENTITY_PROVIDER_ANNOTATION_TYPES.add(InsertEntityProvider.class);
        SQL_ENTITY_PROVIDER_ANNOTATION_TYPES.add(UpdateEntityProvider.class);
        SQL_ENTITY_PROVIDER_ANNOTATION_TYPES.add(DeleteEntityProvider.class);
    }
}

