/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis.builder;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.annotation.MapperAnnotationBuilder;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import tech.wetech.mybatis.ExtConfiguration;
import tech.wetech.mybatis.builder.EntityMapperAnnotationResolver;
import tech.wetech.mybatis.builder.EntityMapping;
import tech.wetech.mybatis.builder.EntityMappingBuilder;
import tech.wetech.mybatis.mapper.Mapper;
import tech.wetech.mybatis.util.EntityMappingUtil;

public class EntityMapperBuilder {
    private final ExtConfiguration configuration;
    private final MapperBuilderAssistant assistant;
    private final Class<?> type;
    public static final Map<String, EntityMapping> TABLE_ENTITY_CACHE = new HashMap<String, EntityMapping>();

    public EntityMapperBuilder(ExtConfiguration configuration, Class<?> type) {
        this.configuration = configuration;
        this.type = type;
        String resource = type.getName().replace('.', '/') + ".java (best guess)";
        this.assistant = new MapperBuilderAssistant((Configuration)configuration, resource);
    }

    public void parse() {
        String resource = this.type.toString();
        if (!this.configuration.isResourceLoaded(resource)) {
            if (Mapper.class.isAssignableFrom(this.type)) {
                Stream.of(this.type.getMethods()).forEach(this::parseStatement);
            }
            this.loadAnnotationResource();
        }
    }

    private void parseStatement(Method method) {
        NoKeyGenerator keyGenerator;
        EntityMapperAnnotationResolver annotationResolver;
        Class<?> entityClass = EntityMappingUtil.extractEntityClass(this.type);
        if (entityClass == null) {
            return;
        }
        EntityMapping entityMapping = TABLE_ENTITY_CACHE.get(entityClass.getName());
        if (entityMapping == null) {
            entityMapping = new EntityMappingBuilder(entityClass).build();
            TABLE_ENTITY_CACHE.put(entityClass.getName(), entityMapping);
        }
        if (!(annotationResolver = new EntityMapperAnnotationResolver(method, this.configuration, entityMapping)).isEntityMethodProvider()) {
            return;
        }
        LanguageDriver languageDriver = this.configuration.getLanguageDriver(XMLLanguageDriver.class);
        this.assistant.setCurrentNamespace(this.type.getName());
        String mappedStatementId = this.type.getName() + "." + method.getName();
        String resultMapId = mappedStatementId + "#resultMap";
        String script = annotationResolver.getScript();
        SqlSource sqlSource = languageDriver.createSqlSource((Configuration)this.configuration, script, entityClass);
        this.applyResultMap(resultMapId, annotationResolver, entityMapping);
        ResultSetType resultSetType = this.configuration.getDefaultResultSetType();
        SqlCommandType sqlCommandType = annotationResolver.getSqlCommandType();
        boolean isSelect = sqlCommandType == SqlCommandType.SELECT;
        boolean flushCache = !isSelect;
        boolean useCache = isSelect;
        String keyProperty = entityMapping.getKeyProperty();
        if (sqlCommandType == SqlCommandType.INSERT && keyProperty != null) {
            keyGenerator = Jdbc3KeyGenerator.INSTANCE;
            if (method.getParameterCount() > 1) {
                ParamNameResolver paramNameResolver = new ParamNameResolver((Configuration)this.configuration, method);
                Type[] resolveParamTypes = TypeParameterResolver.resolveParamTypes((Method)method, this.type);
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    if (!"T".equals(resolveParamTypes[i].getTypeName())) continue;
                    keyProperty = paramNameResolver.getNames()[i] + "." + entityMapping.getKeyProperty();
                    break;
                }
            }
        } else {
            keyGenerator = NoKeyGenerator.INSTANCE;
        }
        this.assistant.addMappedStatement(mappedStatementId, sqlSource, StatementType.PREPARED, sqlCommandType, null, null, null, entityClass, resultMapId, entityClass, resultSetType, flushCache, useCache, false, (KeyGenerator)keyGenerator, keyProperty, entityMapping.getKeyColumn(), this.configuration.getDatabaseId(), languageDriver, null);
    }

    private void loadAnnotationResource() {
        MapperAnnotationBuilder parser = new MapperAnnotationBuilder((Configuration)this.configuration, this.type);
        parser.parse();
    }

    private void applyResultMap(String resultMapId, EntityMapperAnnotationResolver resolver, EntityMapping entityMapping) {
        Method method = resolver.getMethod();
        Class<?> resultType = this.getReturnType(method, resolver);
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        if (resultType == resolver.getEntityMapping().getEntityClass()) {
            resultType = entityMapping.getEntityClass();
            for (EntityMapping.ColumnProperty columnProperty : entityMapping.getColumnProperties()) {
                ResultMapping.Builder builder = new ResultMapping.Builder((Configuration)this.configuration, columnProperty.getPropertyName(), columnProperty.getColumnName().replace("`", ""), columnProperty.getJavaType());
                resultMappings.add(builder.build());
            }
        }
        this.assistant.addResultMap(resultMapId, resultType, null, null, resultMappings, null);
    }

    private Class<?> getReturnType(Method method, EntityMapperAnnotationResolver resolver) {
        Class returnType = method.getReturnType();
        Type resolvedReturnType = TypeParameterResolver.resolveReturnType((Method)method, this.type);
        if ("T".equals(resolvedReturnType.getTypeName())) {
            returnType = resolver.getEntityMapping().getEntityClass();
        }
        if (resolvedReturnType instanceof Class) {
            ResultType rt;
            returnType = (Class)resolvedReturnType;
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
            if (Void.TYPE.equals(returnType) && (rt = method.getAnnotation(ResultType.class)) != null) {
                returnType = rt.value();
            }
        } else if (resolvedReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)resolvedReturnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawType) || Cursor.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments != null && actualTypeArguments.length == 1) {
                    Type returnTypeParameter = actualTypeArguments[0];
                    if (returnTypeParameter instanceof Class) {
                        returnType = (Class)returnTypeParameter;
                    } else if (returnTypeParameter instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter).getRawType();
                    } else if (returnTypeParameter instanceof GenericArrayType) {
                        Class componentType = (Class)((GenericArrayType)returnTypeParameter).getGenericComponentType();
                        returnType = Array.newInstance(componentType, 0).getClass();
                    } else if ("T".equals(returnTypeParameter.getTypeName())) {
                        returnType = resolver.getEntityMapping().getEntityClass();
                    }
                }
            } else if (method.isAnnotationPresent(MapKey.class) && Map.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments != null && actualTypeArguments.length == 2) {
                    Type returnTypeParameter = actualTypeArguments[1];
                    if (returnTypeParameter instanceof Class) {
                        returnType = (Class)returnTypeParameter;
                    } else if (returnTypeParameter instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter).getRawType();
                    }
                }
            } else if (Optional.class.equals((Object)rawType)) {
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                Type returnTypeParameter = actualTypeArguments[0];
                if (returnTypeParameter instanceof Class) {
                    returnType = (Class)returnTypeParameter;
                } else if ("T".equals(returnTypeParameter.getTypeName())) {
                    returnType = resolver.getEntityMapping().getEntityClass();
                }
            }
        }
        return returnType;
    }
}

