/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import tech.wetech.mybatis.annotation.LogicDelete;
import tech.wetech.mybatis.builder.EntityMapping;

public class EntityMappingBuilder {
    private final Class<?> entityClass;
    private final EntityMapping entityMapping;

    public EntityMappingBuilder(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.entityMapping = new EntityMapping();
    }

    public EntityMapping build() {
        this.entityMapping.setEntityClass(this.entityClass);
        this.entityMapping.setTableName(this.getTableName());
        List<EntityMapping.ColumnProperty> columnProperties = this.getColumnProperties();
        this.entityMapping.setColumnProperties(columnProperties);
        this.entityMapping.setKeyProperty(this.buildKeyProperty(columnProperties));
        this.entityMapping.setKeyColumn(this.buildKeyColumn(columnProperties));
        this.entityMapping.setColumnPropertyMap(this.buildColumnPropertiesMap(columnProperties));
        return this.entityMapping;
    }

    private Map<String, EntityMapping.ColumnProperty> buildColumnPropertiesMap(List<EntityMapping.ColumnProperty> columnProperties) {
        HashMap<String, EntityMapping.ColumnProperty> columnPropertyMap = new HashMap<String, EntityMapping.ColumnProperty>();
        for (EntityMapping.ColumnProperty columnProperty : columnProperties) {
            columnPropertyMap.put(columnProperty.getPropertyName(), columnProperty);
        }
        return columnPropertyMap;
    }

    private String getTableName() {
        StringBuilder builder = new StringBuilder();
        if (this.entityClass.isAnnotationPresent(Table.class)) {
            Table table = this.getRequiredAnnotation(Table.class);
            if (!table.catalog().isEmpty()) {
                builder.append(table.catalog()).append('.');
            }
            if (!table.schema().isEmpty()) {
                builder.append(table.schema()).append('.');
            }
            if (!table.name().isEmpty()) {
                builder.append(table.name());
            } else {
                builder.append(this.camelhumpToUnderline(this.entityClass.getName()));
            }
        } else {
            builder.append(this.camelhumpToUnderline(this.entityClass.getName()));
        }
        return builder.toString();
    }

    private List<Field> getAllFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> tempClass = this.entityClass; tempClass != null && !tempClass.equals(Object.class); tempClass = tempClass.getSuperclass()) {
            fields.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        return fields;
    }

    private List<EntityMapping.ColumnProperty> getColumnProperties() {
        List<Field> fields = this.getAllFields();
        ArrayList<EntityMapping.ColumnProperty> columnProperties = new ArrayList<EntityMapping.ColumnProperty>();
        for (Field field : fields) {
            if (field.isAnnotationPresent(Transient.class)) continue;
            EntityMapping.ColumnProperty columnProperty = new EntityMapping.ColumnProperty();
            columnProperty.setAnnotations(Arrays.asList(field.getAnnotations()));
            columnProperty.setPropertyName(field.getName());
            columnProperty.setJavaType(field.getType());
            if (field.isAnnotationPresent(Column.class)) {
                Column column = field.getAnnotation(Column.class);
                columnProperty.setColumnName(column.name());
            } else {
                String s = this.camelhumpToUnderline(field.getName());
                columnProperty.setColumnName(s);
            }
            if (field.isAnnotationPresent(Id.class)) {
                columnProperty.setIdentity(true);
            }
            if (field.isAnnotationPresent(LogicDelete.class)) {
                LogicDelete logicDelete = field.getAnnotation(LogicDelete.class);
                this.entityMapping.setLogicDelete(true);
                this.entityMapping.setLogicDeleteColumn(columnProperty.getColumnName());
                this.entityMapping.setLogicDeleteNormalValue(logicDelete.normalValue());
                this.entityMapping.setLogicDeleteDeletedValue(logicDelete.deletedValue());
            }
            if (field.isAnnotationPresent(Version.class)) {
                this.entityMapping.setOptimisticLock(true);
                this.entityMapping.setOptimisticLockColumn(columnProperty.getColumnName());
                this.entityMapping.setOptimisticLockProperty(columnProperty.getPropertyName());
            }
            columnProperties.add(columnProperty);
        }
        return columnProperties;
    }

    private <A extends Annotation> A getRequiredAnnotation(Class<A> annotationType) throws IllegalStateException {
        A annotation = this.entityClass.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        throw new IllegalStateException(String.format("Required annotation %s not found for %s!", annotationType, annotationType.getName()));
    }

    private String buildKeyProperty(List<EntityMapping.ColumnProperty> columnProperties) {
        for (EntityMapping.ColumnProperty columnProperty : columnProperties) {
            if (!columnProperty.isIdentity()) continue;
            return columnProperty.getPropertyName();
        }
        return null;
    }

    private String buildKeyColumn(List<EntityMapping.ColumnProperty> columnProperties) {
        for (EntityMapping.ColumnProperty columnProperty : columnProperties) {
            if (!columnProperty.isIdentity()) continue;
            return columnProperty.getColumnName();
        }
        return null;
    }

    private String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (EntityMappingBuilder.isUppercaseAlpha(c)) {
                sb.append('_').append(EntityMappingBuilder.toLowerAscii(c));
                continue;
            }
            sb.append(c);
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static char toLowerAscii(char c) {
        if (EntityMappingBuilder.isUppercaseAlpha(c)) {
            c = (char)(c + 32);
        }
        return c;
    }
}

