/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis.dialect;

import java.util.HashMap;
import java.util.Map;
import tech.wetech.mybatis.dialect.Dialect;
import tech.wetech.mybatis.dialect.DialectType;
import tech.wetech.mybatis.dialect.db.DB2Dialect;
import tech.wetech.mybatis.dialect.db.H2Dialect;
import tech.wetech.mybatis.dialect.db.HSQLDialect;
import tech.wetech.mybatis.dialect.db.MySQLDialect;
import tech.wetech.mybatis.dialect.db.OracleDialect;
import tech.wetech.mybatis.dialect.db.PostgreSQLDialect;
import tech.wetech.mybatis.dialect.db.SQLServerDialect;
import tech.wetech.mybatis.dialect.db.SqlServer2012Dialect;

public class DialectClient {
    private static final Map<DialectType, Dialect> DBMS_DIALECT = new HashMap<DialectType, Dialect>();

    public static Dialect getDialect(DialectType dialectType) {
        if (DBMS_DIALECT.containsKey((Object)dialectType)) {
            return DBMS_DIALECT.get((Object)dialectType);
        }
        Dialect dialect = DialectClient.createDialect(dialectType);
        DBMS_DIALECT.put(dialectType, dialect);
        return dialect;
    }

    private static Dialect createDialect(DialectType dialectType) {
        switch (dialectType) {
            case MYSQL: {
                return new MySQLDialect();
            }
            case ORACLE: {
                return new OracleDialect();
            }
            case DB2: {
                return new DB2Dialect();
            }
            case POSTGRE: {
                return new PostgreSQLDialect();
            }
            case H2: {
                return new H2Dialect();
            }
            case HSQL: {
                return new HSQLDialect();
            }
            case SQLSERVER: {
                return new SQLServerDialect();
            }
            case SQLSERVER2012: {
                return new SqlServer2012Dialect();
            }
        }
        throw new UnsupportedOperationException("Empty dbms dialect");
    }
}

