/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis.example;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import tech.wetech.mybatis.ThreadContext;
import tech.wetech.mybatis.domain.Property;
import tech.wetech.mybatis.example.Criteria;
import tech.wetech.mybatis.example.Sort;
import tech.wetech.mybatis.util.EntityMappingUtil;

public class Example<T>
implements Serializable {
    protected List<String> columns;
    protected boolean distinct;
    protected String orderByClause;
    protected final Class<?> entityClass;
    protected List<Criteria> oredCriteria;

    public Criteria<T> or() {
        Criteria<T> criteria = this.createCriteriaInternal();
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria<T> or(Criteria<T> criteria) {
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria<T> and() {
        Criteria<T> criteria = this.createCriteriaInternal();
        criteria.andOr("and");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria<T> and(Criteria<T> criteria) {
        this.oredCriteria.add(criteria);
        criteria.andOr("and");
        return criteria;
    }

    public static <T> Example<T> of(Class<T> entityClass) {
        return new Example<T>(entityClass);
    }

    public Criteria<T> createCriteria() {
        Criteria<T> criteria = this.createCriteriaInternal();
        if (this.oredCriteria.size() == 0) {
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria<T> createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public Example(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.oredCriteria = new ArrayList<Criteria>();
    }

    public void clear() {
        this.oredCriteria.clear();
        this.orderByClause = null;
        this.distinct = false;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public Example<T> setSelects(Property<T, ?> ... properties) {
        this.columns = Arrays.stream(properties).map(p -> p.getColumnName(this.entityClass.getName())).collect(Collectors.toList());
        return this;
    }

    public Example<T> setSelects(String ... properties) {
        this.columns = Arrays.asList(properties);
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Example<T> setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Example<T> setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public Example<T> setPage(int pageSize, int pageNumber) {
        ThreadContext.setPage(pageSize, pageNumber);
        return this;
    }

    public Example<T> setSort(Sort sort) {
        if (sort.getOrders() != null && sort.getOrders().size() > 0) {
            this.orderByClause = sort.getOrders().stream().map(order -> EntityMappingUtil.getColumnName(this.entityClass.getName(), order.getProperty()).concat(" ").concat(order.getDirection().toString())).collect(Collectors.joining(","));
        }
        return this;
    }

    public String toString() {
        return "Example{columns=" + this.columns + ", distinct=" + this.distinct + ", orderByClause='" + this.orderByClause + '\'' + ", oredCriteria=" + this.oredCriteria + ", entityClass=" + this.entityClass + '}';
    }
}

