/*
 * Decompiled with CFR 0.152.
 */
package tech.wetech.mybatis.util;

import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.function.Function;
import org.apache.ibatis.binding.BindingException;
import tech.wetech.mybatis.builder.EntityMapperBuilder;
import tech.wetech.mybatis.builder.EntityMapping;

public class EntityMappingUtil {
    public static String getColumnName(String className, String property) {
        EntityMapping entityMapping = EntityMapperBuilder.TABLE_ENTITY_CACHE.get(className);
        Map<String, EntityMapping.ColumnProperty> columnPropertyMap = entityMapping.getColumnPropertyMap();
        EntityMapping.ColumnProperty columnProperty = columnPropertyMap.get(property);
        if (columnProperty == null) {
            throw new BindingException("Property " + property + " is not mapping to the EntityMapping.");
        }
        return columnProperty.getColumnName();
    }

    public static <FN extends Function> String getColumnName(String className, FN fn) {
        return EntityMappingUtil.getColumnName(className, EntityMappingUtil.getFunctionName(fn));
    }

    public static Class<?> extractEntityClass(Class<?> mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            Type t;
            Type[] typeArray;
            int n;
            int n2;
            if (!(type instanceof ParameterizedType)) continue;
            Type[] typeArray2 = ((ParameterizedType)type).getActualTypeArguments();
            if (typeArray2 == null || typeArray2.length <= 0 || (n2 = 0) >= (n = (typeArray = typeArray2).length) || (t = typeArray[n2]) instanceof TypeVariable || t instanceof WildcardType) break;
            target = (ParameterizedType)type;
            break;
        }
        return target == null ? null : (Class)target.getActualTypeArguments()[0];
    }

    public static <FN extends Function> String getFunctionName(FN fn) {
        try {
            Method declaredMethod = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            declaredMethod.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)declaredMethod.invoke(fn, new Object[0]);
            String method = serializedLambda.getImplMethodName();
            String attr = null;
            attr = method.startsWith("get") ? method.substring(3) : method.substring(2);
            return Introspector.decapitalize(attr);
        }
        catch (ReflectiveOperationException var6) {
            throw new RuntimeException(var6);
        }
    }
}

