/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.elixirapi.requests.player;

import java.util.function.Consumer;
import tech.xigam.elixirapi.ElixirAPI;
import tech.xigam.elixirapi.Request;
import tech.xigam.elixirapi.Response;
import tech.xigam.elixirapi.exceptions.RequestBuildException;
import tech.xigam.elixirapi.interfaces.PlayerResponse;
import tech.xigam.elixirapi.requests.player.PlayerRequest;
import tech.xigam.elixirapi.responses.GenericPlayerResponse;

public final class ResumeRequest
extends PlayerRequest {
    private final String guild;

    public ResumeRequest(ElixirAPI api, String guild) {
        super(api);
        this.guild = guild;
    }

    @Override
    public void execute(Consumer<PlayerResponse> response) {
        Request request = new Request.Builder(this.api).method(Request.Method.POST).endpoint("resume").argument("guild", this.guild).build();
        request.execute((Response res) -> new GenericPlayerResponse(res.getResponse(), res.getResponseCode()));
    }

    public static class Builder
    extends PlayerRequest.Builder {
        public Builder(ElixirAPI api) {
            super(api);
        }

        @Override
        public PlayerRequest build() throws RequestBuildException {
            return new ResumeRequest(this.api, this.guild);
        }
    }
}

