package tech.yixiyun.framework.kuafu.bean;

/**
 * Bean对象状态
 */
public enum BeanState {
    /**
     * 未初始化
     */
    NOT_INIT(1),

    /**
     * 初始化中
     */
    INITING(2),

    /**
     * 合作态，当一个单例Bean初始时，其他线程也依赖它，就会更新状态为合作态。
     * 合作态的Bean，完成初始化必须更新状态为READY,等待所有合作态都READY后才可OVRE
     */
    COOPERATING(3),

    /**
     * 预备态，表示它已完成注入
     */
    READY(4),

    /**
     * 尝试完结，一旦失败回退READY。由Ready转Over的一个缓冲状态
     */
    TRY_OVER(5),

    /**
     * 结束态，表示可以被外界获取了
     */
    OVER(6);

    private BeanState(int value) {
        this.value = value;
    }

    private int value;

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}
