package tech.yixiyun.framework.kuafu.bean.annotation;


import tech.yixiyun.framework.kuafu.bean.BeanMode;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface Bean {


    /**
     * 在系统启动后立即实例化，还是被使用时才实例化
     * @return
     */
    boolean lazyInit() default false;

    /**
     * 实例化方式，单例还是多例，默认单例
     * @return
     */
    BeanMode mode() default BeanMode.SINGLETON;

    /**
     * 对该组件类的备注
     * @return
     */
    String remark() default "";
}
